/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Permiso;
import com.sistema.turistico.entity.Rol;
import com.sistema.turistico.entity.Sucursal;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Set;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="usuarios")
@EntityListeners(value={AuditingEntityListener.class})
public class Usuario {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_usuario")
    private Long idUsuario;
    @NotBlank(message="El nombre es obligatorio")
    @Size(max=100, message="El nombre no puede exceder 100 caracteres")
    @Column(name="nombre", nullable=false, length=100)
    private @NotBlank(message="El nombre es obligatorio") @Size(max=100, message="El nombre no puede exceder 100 caracteres") String nombre;
    @NotBlank(message="El apellido es obligatorio")
    @Size(max=100, message="El apellido no puede exceder 100 caracteres")
    @Column(name="apellido", nullable=false, length=100)
    private @NotBlank(message="El apellido es obligatorio") @Size(max=100, message="El apellido no puede exceder 100 caracteres") String apellido;
    @NotBlank(message="El email es obligatorio")
    @Email(message="El email debe tener un formato v\u00e1lido")
    @Size(max=255, message="El email no puede exceder 255 caracteres")
    @Column(name="email", nullable=false, unique=true, length=255)
    private @NotBlank(message="El email es obligatorio") @Email(message="El email debe tener un formato v\u00e1lido") @Size(max=255, message="El email no puede exceder 255 caracteres") String email;
    @NotBlank(message="La contrase\u00f1a es obligatoria")
    @Size(max=255, message="La contrase\u00f1a no puede exceder 255 caracteres")
    @Column(name="password_hash", nullable=false, length=255)
    private @NotBlank(message="La contrase\u00f1a es obligatoria") @Size(max=255, message="La contrase\u00f1a no puede exceder 255 caracteres") String passwordHash;
    @Size(max=20, message="El DNI no puede exceder 20 caracteres")
    @Column(name="dni", unique=true, length=20)
    private @Size(max=20, message="El DNI no puede exceder 20 caracteres") String dni;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_rol", nullable=false)
    private Rol rol;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;
    @Column(name="ultimo_login")
    private LocalDateTime ultimoLogin;
    @Column(name="intentos_fallidos", nullable=false)
    private Integer intentosFallidos = 0;
    @Column(name="bloqueado_hasta")
    private LocalDateTime bloqueadoHasta;
    @JsonIgnore
    @Column(name="token", length=512)
    private String token;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="roles_permisos", joinColumns={@JoinColumn(name="id_rol")}, inverseJoinColumns={@JoinColumn(name="id_permiso")})
    private Set<Permiso> permisos;

    public Long getIdUsuario() {
        return this.idUsuario;
    }

    public String getNombre() {
        return this.nombre;
    }

    public String getApellido() {
        return this.apellido;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public String getDni() {
        return this.dni;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public Rol getRol() {
        return this.rol;
    }

    public Sucursal getSucursal() {
        return this.sucursal;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public LocalDateTime getUltimoLogin() {
        return this.ultimoLogin;
    }

    public Integer getIntentosFallidos() {
        return this.intentosFallidos;
    }

    public LocalDateTime getBloqueadoHasta() {
        return this.bloqueadoHasta;
    }

    public String getToken() {
        return this.token;
    }

    public Set<Permiso> getPermisos() {
        return this.permisos;
    }

    public void setIdUsuario(Long idUsuario) {
        this.idUsuario = idUsuario;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public void setApellido(String apellido) {
        this.apellido = apellido;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public void setDni(String dni) {
        this.dni = dni;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setRol(Rol rol) {
        this.rol = rol;
    }

    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public void setUltimoLogin(LocalDateTime ultimoLogin) {
        this.ultimoLogin = ultimoLogin;
    }

    public void setIntentosFallidos(Integer intentosFallidos) {
        this.intentosFallidos = intentosFallidos;
    }

    public void setBloqueadoHasta(LocalDateTime bloqueadoHasta) {
        this.bloqueadoHasta = bloqueadoHasta;
    }

    @JsonIgnore
    public void setToken(String token) {
        this.token = token;
    }

    public void setPermisos(Set<Permiso> permisos) {
        this.permisos = permisos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usuario)) {
            return false;
        }
        Usuario other = (Usuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idUsuario = this.getIdUsuario();
        Long other$idUsuario = other.getIdUsuario();
        if (this$idUsuario == null ? other$idUsuario != null : !((Object)this$idUsuario).equals(other$idUsuario)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Integer this$intentosFallidos = this.getIntentosFallidos();
        Integer other$intentosFallidos = other.getIntentosFallidos();
        if (this$intentosFallidos == null ? other$intentosFallidos != null : !((Object)this$intentosFallidos).equals(other$intentosFallidos)) {
            return false;
        }
        String this$nombre = this.getNombre();
        String other$nombre = other.getNombre();
        if (this$nombre == null ? other$nombre != null : !this$nombre.equals(other$nombre)) {
            return false;
        }
        String this$apellido = this.getApellido();
        String other$apellido = other.getApellido();
        if (this$apellido == null ? other$apellido != null : !this$apellido.equals(other$apellido)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$passwordHash = this.getPasswordHash();
        String other$passwordHash = other.getPasswordHash();
        if (this$passwordHash == null ? other$passwordHash != null : !this$passwordHash.equals(other$passwordHash)) {
            return false;
        }
        String this$dni = this.getDni();
        String other$dni = other.getDni();
        if (this$dni == null ? other$dni != null : !this$dni.equals(other$dni)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Rol this$rol = this.getRol();
        Rol other$rol = other.getRol();
        if (this$rol == null ? other$rol != null : !this$rol.equals(other$rol)) {
            return false;
        }
        Sucursal this$sucursal = this.getSucursal();
        Sucursal other$sucursal = other.getSucursal();
        if (this$sucursal == null ? other$sucursal != null : !this$sucursal.equals(other$sucursal)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        LocalDateTime this$ultimoLogin = this.getUltimoLogin();
        LocalDateTime other$ultimoLogin = other.getUltimoLogin();
        if (this$ultimoLogin == null ? other$ultimoLogin != null : !((Object)this$ultimoLogin).equals(other$ultimoLogin)) {
            return false;
        }
        LocalDateTime this$bloqueadoHasta = this.getBloqueadoHasta();
        LocalDateTime other$bloqueadoHasta = other.getBloqueadoHasta();
        if (this$bloqueadoHasta == null ? other$bloqueadoHasta != null : !((Object)this$bloqueadoHasta).equals(other$bloqueadoHasta)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Set this$permisos = this.getPermisos();
        Set other$permisos = other.getPermisos();
        return !(this$permisos == null ? other$permisos != null : !((Object)this$permisos).equals(other$permisos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Usuario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idUsuario = this.getIdUsuario();
        result = result * 59 + ($idUsuario == null ? 43 : ((Object)$idUsuario).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Integer $intentosFallidos = this.getIntentosFallidos();
        result = result * 59 + ($intentosFallidos == null ? 43 : ((Object)$intentosFallidos).hashCode());
        String $nombre = this.getNombre();
        result = result * 59 + ($nombre == null ? 43 : $nombre.hashCode());
        String $apellido = this.getApellido();
        result = result * 59 + ($apellido == null ? 43 : $apellido.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $passwordHash = this.getPasswordHash();
        result = result * 59 + ($passwordHash == null ? 43 : $passwordHash.hashCode());
        String $dni = this.getDni();
        result = result * 59 + ($dni == null ? 43 : $dni.hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Rol $rol = this.getRol();
        result = result * 59 + ($rol == null ? 43 : $rol.hashCode());
        Sucursal $sucursal = this.getSucursal();
        result = result * 59 + ($sucursal == null ? 43 : $sucursal.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        LocalDateTime $ultimoLogin = this.getUltimoLogin();
        result = result * 59 + ($ultimoLogin == null ? 43 : ((Object)$ultimoLogin).hashCode());
        LocalDateTime $bloqueadoHasta = this.getBloqueadoHasta();
        result = result * 59 + ($bloqueadoHasta == null ? 43 : ((Object)$bloqueadoHasta).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Set $permisos = this.getPermisos();
        result = result * 59 + ($permisos == null ? 43 : ((Object)$permisos).hashCode());
        return result;
    }

    public String toString() {
        return "Usuario(idUsuario=" + this.getIdUsuario() + ", nombre=" + this.getNombre() + ", apellido=" + this.getApellido() + ", email=" + this.getEmail() + ", passwordHash=" + this.getPasswordHash() + ", dni=" + this.getDni() + ", estado=" + this.getEstado() + ", empresa=" + String.valueOf(this.getEmpresa()) + ", rol=" + String.valueOf(this.getRol()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", ultimoLogin=" + String.valueOf(this.getUltimoLogin()) + ", intentosFallidos=" + this.getIntentosFallidos() + ", bloqueadoHasta=" + String.valueOf(this.getBloqueadoHasta()) + ", token=" + this.getToken() + ", permisos=" + String.valueOf(this.getPermisos()) + ")";
    }

    public Usuario() {
    }

    public Usuario(Long idUsuario, String nombre, String apellido, String email, String passwordHash, String dni, Integer estado, Empresa empresa, Rol rol, Sucursal sucursal, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime deletedAt, LocalDateTime ultimoLogin, Integer intentosFallidos, LocalDateTime bloqueadoHasta, String token, Set<Permiso> permisos) {
        this.idUsuario = idUsuario;
        this.nombre = nombre;
        this.apellido = apellido;
        this.email = email;
        this.passwordHash = passwordHash;
        this.dni = dni;
        this.estado = estado;
        this.empresa = empresa;
        this.rol = rol;
        this.sucursal = sucursal;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
        this.ultimoLogin = ultimoLogin;
        this.intentosFallidos = intentosFallidos;
        this.bloqueadoHasta = bloqueadoHasta;
        this.token = token;
        this.permisos = permisos;
    }
}

