/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="ventas")
public class Venta {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_venta")
    private Long idVenta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_cliente")
    private Cliente cliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva")
    private Reserva reserva;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario", nullable=false)
    private Usuario usuario;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_caja", nullable=false)
    private Caja caja;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @Column(name="fecha_hora", nullable=false)
    private LocalDateTime fechaHora;
    @NotNull
    @DecimalMin(value="0.01", message="El monto total debe ser mayor a 0")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_total", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.01", message="El monto total debe ser mayor a 0") @Digits(integer=10, fraction=2) BigDecimal montoTotal;
    @Column(name="metodo_pago", nullable=false, length=50)
    private String metodoPago;
    @Column(name="numero_operacion", length=100)
    private String numeroOperacion;
    @Column(name="comprobante", length=100)
    private String comprobante;
    @Digits(integer=10, fraction=2)
    @Column(name="descuento", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal descuento = BigDecimal.ZERO;
    @Digits(integer=10, fraction=2)
    @Column(name="propina", precision=10, scale=2)
    private @Digits(integer=10, fraction=2) BigDecimal propina = BigDecimal.ZERO;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @Column(name="estado", nullable=false)
    private Boolean estado = Boolean.TRUE;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    public Long getIdVenta() {
        return this.idVenta;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public Reserva getReserva() {
        return this.reserva;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public Caja getCaja() {
        return this.caja;
    }

    public Sucursal getSucursal() {
        return this.sucursal;
    }

    public LocalDateTime getFechaHora() {
        return this.fechaHora;
    }

    public BigDecimal getMontoTotal() {
        return this.montoTotal;
    }

    public String getMetodoPago() {
        return this.metodoPago;
    }

    public String getNumeroOperacion() {
        return this.numeroOperacion;
    }

    public String getComprobante() {
        return this.comprobante;
    }

    public BigDecimal getDescuento() {
        return this.descuento;
    }

    public BigDecimal getPropina() {
        return this.propina;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public Boolean getEstado() {
        return this.estado;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setIdVenta(Long idVenta) {
        this.idVenta = idVenta;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setCaja(Caja caja) {
        this.caja = caja;
    }

    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    public void setFechaHora(LocalDateTime fechaHora) {
        this.fechaHora = fechaHora;
    }

    public void setMontoTotal(BigDecimal montoTotal) {
        this.montoTotal = montoTotal;
    }

    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    public void setNumeroOperacion(String numeroOperacion) {
        this.numeroOperacion = numeroOperacion;
    }

    public void setComprobante(String comprobante) {
        this.comprobante = comprobante;
    }

    public void setDescuento(BigDecimal descuento) {
        this.descuento = descuento;
    }

    public void setPropina(BigDecimal propina) {
        this.propina = propina;
    }

    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String toString() {
        return "Venta(idVenta=" + this.getIdVenta() + ", empresa=" + String.valueOf(this.getEmpresa()) + ", cliente=" + String.valueOf(this.getCliente()) + ", reserva=" + String.valueOf(this.getReserva()) + ", usuario=" + String.valueOf(this.getUsuario()) + ", caja=" + String.valueOf(this.getCaja()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", fechaHora=" + String.valueOf(this.getFechaHora()) + ", montoTotal=" + String.valueOf(this.getMontoTotal()) + ", metodoPago=" + this.getMetodoPago() + ", numeroOperacion=" + this.getNumeroOperacion() + ", comprobante=" + this.getComprobante() + ", descuento=" + String.valueOf(this.getDescuento()) + ", propina=" + String.valueOf(this.getPropina()) + ", observaciones=" + this.getObservaciones() + ", estado=" + this.getEstado() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Venta)) {
            return false;
        }
        Venta other = (Venta)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idVenta = this.getIdVenta();
        Long other$idVenta = other.getIdVenta();
        return !(this$idVenta == null ? other$idVenta != null : !((Object)this$idVenta).equals(other$idVenta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Venta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idVenta = this.getIdVenta();
        result = result * 59 + ($idVenta == null ? 43 : ((Object)$idVenta).hashCode());
        return result;
    }
}

