/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.ServicioTuristico;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ServicioTuristicoRepository
extends JpaRepository<ServicioTuristico, Long> {
    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL")
    public List<ServicioTuristico> findByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND (s.sucursal IS NULL OR s.sucursal.idSucursal = :sucursalId) AND s.estado = true AND s.deletedAt IS NULL")
    public List<ServicioTuristico> findByEmpresaIdAndSucursalId(@Param(value="empresaId") Long var1, @Param(value="sucursalId") Long var2);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL ORDER BY s.createdAt DESC")
    public List<ServicioTuristico> findByEmpresaIdOrderByCreatedAtDesc(@Param(value="empresaId") Long var1);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.tipoServicio = :tipoServicio AND s.estado = true AND s.deletedAt IS NULL")
    public List<ServicioTuristico> findByEmpresaIdAndTipoServicio(@Param(value="empresaId") Long var1, @Param(value="tipoServicio") ServicioTuristico.TipoServicio var2);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.idCategoria = :categoriaId AND s.estado = true AND s.deletedAt IS NULL")
    public List<ServicioTuristico> findByEmpresaIdAndCategoriaId(@Param(value="empresaId") Long var1, @Param(value="categoriaId") Long var2);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL AND (LOWER(s.nombreServicio) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.descripcion) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.ubicacionDestino) LIKE LOWER(CONCAT('%', :busqueda, '%')))")
    public List<ServicioTuristico> findByEmpresaIdAndBusqueda(@Param(value="empresaId") Long var1, @Param(value="busqueda") String var2);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL AND s.precioBase BETWEEN :precioMin AND :precioMax")
    public List<ServicioTuristico> findByEmpresaIdAndPrecioBetween(@Param(value="empresaId") Long var1, @Param(value="precioMin") BigDecimal var2, @Param(value="precioMax") BigDecimal var3);

    @Query(value="SELECT s FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL AND s.capacidadMaxima >= :personasRequeridas")
    public List<ServicioTuristico> findDisponiblesByEmpresaIdAndPersonas(@Param(value="empresaId") Long var1, @Param(value="personasRequeridas") Integer var2);

    @Query(value="SELECT COUNT(s) FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL")
    public Long countByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT s.tipoServicio, COUNT(s) FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.estado = true AND s.deletedAt IS NULL GROUP BY s.tipoServicio")
    public List<Object[]> countServiciosByTipo(@Param(value="empresaId") Long var1);

    @Query(value="SELECT COUNT(s) > 0 FROM ServicioTuristico s WHERE s.empresa.idEmpresa = :empresaId AND s.nombreServicio = :nombreServicio AND s.idServicio != :excludeId")
    public boolean existsByEmpresaIdAndNombreServicioAndIdNot(@Param(value="empresaId") Long var1, @Param(value="nombreServicio") String var2, @Param(value="excludeId") Long var3);
}

