/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.EmpresaRequest;
import com.sistema.turistico.dto.EmpresaResponse;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.repository.EmpresaRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EmpresaService {
    private static final Logger log = LoggerFactory.getLogger(EmpresaService.class);
    private final EmpresaRepository empresaRepository;

    public Empresa crear(EmpresaRequest request) {
        log.info("Creando nueva empresa con RUC {}", (Object)request.getRuc());
        String ruc = request.getRuc().trim();
        if (this.empresaRepository.existsByRuc(ruc)) {
            throw new IllegalArgumentException("Ya existe una empresa con este RUC");
        }
        String email = request.getEmail().trim();
        if (this.empresaRepository.existsByEmail(email)) {
            throw new IllegalArgumentException("Ya existe una empresa con este email");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado de la empresa debe ser 0 (Inactivo) o 1 (Activo)");
        }
        Empresa empresa = new Empresa();
        empresa.setNombreEmpresa(request.getNombreEmpresa().trim());
        empresa.setRuc(ruc);
        empresa.setEmail(email);
        empresa.setTelefono(request.getTelefono() != null ? request.getTelefono().trim() : null);
        empresa.setDireccion(request.getDireccion() != null ? request.getDireccion().trim() : null);
        empresa.setEstado(Integer.valueOf(estado != null ? estado : 1));
        empresa.setFechaRegistro(LocalDateTime.now());
        empresa.setDeletedAt(null);
        Empresa creada = (Empresa)this.empresaRepository.save((Object)empresa);
        log.info("Empresa creada exitosamente con ID {}", (Object)creada.getIdEmpresa());
        return creada;
    }

    @Transactional(readOnly=true)
    public List<Empresa> listar(String busqueda, Integer estado) {
        String criterio;
        String string = criterio = busqueda != null && !busqueda.trim().isEmpty() ? busqueda.trim() : null;
        if (criterio == null && estado == null) {
            return this.empresaRepository.findAllActivas();
        }
        return this.empresaRepository.findByFiltros(criterio, estado);
    }

    @Transactional(readOnly=true)
    public Empresa obtenerPorId(Long id) {
        return (Empresa)this.empresaRepository.findActivaById(id).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    public Empresa actualizar(Long id, EmpresaRequest request) {
        log.info("Actualizando empresa {}", (Object)id);
        Empresa existente = this.obtenerPorId(id);
        String nuevoRuc = request.getRuc().trim();
        if (!existente.getRuc().equals(nuevoRuc) && this.empresaRepository.existsByRucAndIdEmpresaNot(nuevoRuc, id)) {
            throw new IllegalArgumentException("Ya existe una empresa con este RUC");
        }
        String nuevoEmail = request.getEmail().trim();
        if (!existente.getEmail().equalsIgnoreCase(nuevoEmail) && this.empresaRepository.existsByEmailAndIdEmpresaNot(nuevoEmail, id)) {
            throw new IllegalArgumentException("Ya existe una empresa con este email");
        }
        Integer estado = request.getEstado();
        if (estado != null && estado != 0 && estado != 1) {
            throw new IllegalArgumentException("El estado de la empresa debe ser 0 (Inactivo) o 1 (Activo)");
        }
        existente.setNombreEmpresa(request.getNombreEmpresa().trim());
        existente.setRuc(nuevoRuc);
        existente.setEmail(nuevoEmail);
        existente.setTelefono(request.getTelefono() != null ? request.getTelefono().trim() : null);
        existente.setDireccion(request.getDireccion() != null ? request.getDireccion().trim() : null);
        if (estado != null) {
            existente.setEstado(estado);
        }
        Empresa actualizada = (Empresa)this.empresaRepository.save((Object)existente);
        log.info("Empresa actualizada exitosamente {}", (Object)actualizada.getIdEmpresa());
        return actualizada;
    }

    public void eliminar(Long id) {
        log.info("Eliminando empresa (soft delete) {}", (Object)id);
        Empresa empresa = this.obtenerPorId(id);
        empresa.setEstado(Integer.valueOf(0));
        empresa.setDeletedAt(LocalDateTime.now());
        this.empresaRepository.save((Object)empresa);
    }

    @Transactional(readOnly=true)
    public EmpresaResponse toResponse(Empresa empresa) {
        return new EmpresaResponse(empresa.getIdEmpresa(), empresa.getNombreEmpresa(), empresa.getRuc(), empresa.getEmail(), empresa.getTelefono(), empresa.getDireccion(), empresa.getEstado(), empresa.getFechaRegistro() != null ? empresa.getFechaRegistro().toString() : null, empresa.getCreatedAt() != null ? empresa.getCreatedAt().toString() : null, empresa.getUpdatedAt() != null ? empresa.getUpdatedAt().toString() : null, empresa.getDeletedAt() != null ? empresa.getDeletedAt().toString() : null);
    }

    public EmpresaService(EmpresaRepository empresaRepository) {
        this.empresaRepository = empresaRepository;
    }
}

