/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.entity.EvaluacionServicio;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.repository.EvaluacionServicioRepository;
import com.sistema.turistico.repository.ReservaRepository;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvaluacionServicioService {
    private static final Logger log = LoggerFactory.getLogger(EvaluacionServicioService.class);
    private final EvaluacionServicioRepository evaluacionRepository;
    private final ReservaRepository reservaRepository;

    @Transactional
    public EvaluacionServicio create(EvaluacionServicio evaluacion) {
        log.info("Creando evaluaci\u00f3n para reserva: {}", (Object)evaluacion.getReserva().getIdReserva());
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)evaluacion.getReserva().getIdReserva()).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (reserva.getEstado() != Reserva.EstadoReserva.Completada) {
            throw new IllegalArgumentException("Solo se pueden evaluar reservas completadas");
        }
        if (this.evaluacionRepository.existsByReservaId(reserva.getIdReserva())) {
            throw new IllegalArgumentException("Ya existe una evaluaci\u00f3n para esta reserva");
        }
        if (!evaluacion.getCliente().getIdCliente().equals(reserva.getCliente().getIdCliente())) {
            throw new IllegalArgumentException("El cliente de la evaluaci\u00f3n no coincide con el de la reserva");
        }
        evaluacion.setEstado(Boolean.valueOf(true));
        return (EvaluacionServicio)this.evaluacionRepository.save((Object)evaluacion);
    }

    public Optional<EvaluacionServicio> findById(Long id) {
        return this.evaluacionRepository.findById((Object)id);
    }

    public Optional<EvaluacionServicio> findByReservaId(Long reservaId) {
        return this.evaluacionRepository.findByReservaIdUnique(reservaId);
    }

    public List<EvaluacionServicio> findByReservaIdList(Long reservaId) {
        return this.evaluacionRepository.findByReservaId(reservaId);
    }

    public List<EvaluacionServicio> findByClienteId(Long clienteId) {
        return this.evaluacionRepository.findByClienteId(clienteId);
    }

    public List<EvaluacionServicio> findByServicioId(Long servicioId) {
        return this.evaluacionRepository.findByServicioId(servicioId);
    }

    public List<EvaluacionServicio> findByPaqueteId(Long paqueteId) {
        return this.evaluacionRepository.findByPaqueteId(paqueteId);
    }

    public List<EvaluacionServicio> findByCalificacionGeneral(Integer calificacion) {
        return this.evaluacionRepository.findByCalificacionGeneral(calificacion);
    }

    public List<EvaluacionServicio> findByCalificacionBetween(Integer min, Integer max) {
        return this.evaluacionRepository.findByCalificacionGeneralBetween(min, max);
    }

    @Transactional
    public EvaluacionServicio update(Long id, EvaluacionServicio evaluacionActualizada) {
        log.info("Actualizando evaluaci\u00f3n ID: {}", (Object)id);
        EvaluacionServicio evaluacionExistente = (EvaluacionServicio)this.evaluacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Evaluaci\u00f3n no encontrada"));
        if (evaluacionActualizada.getCalificacionGeneral() != null) {
            evaluacionExistente.setCalificacionGeneral(evaluacionActualizada.getCalificacionGeneral());
        }
        if (evaluacionActualizada.getCalificacionGuia() != null) {
            evaluacionExistente.setCalificacionGuia(evaluacionActualizada.getCalificacionGuia());
        }
        if (evaluacionActualizada.getCalificacionTransporte() != null) {
            evaluacionExistente.setCalificacionTransporte(evaluacionActualizada.getCalificacionTransporte());
        }
        if (evaluacionActualizada.getCalificacionHotel() != null) {
            evaluacionExistente.setCalificacionHotel(evaluacionActualizada.getCalificacionHotel());
        }
        if (evaluacionActualizada.getComentarioGeneral() != null) {
            evaluacionExistente.setComentarioGeneral(evaluacionActualizada.getComentarioGeneral());
        }
        if (evaluacionActualizada.getComentarioGuia() != null) {
            evaluacionExistente.setComentarioGuia(evaluacionActualizada.getComentarioGuia());
        }
        if (evaluacionActualizada.getComentarioTransporte() != null) {
            evaluacionExistente.setComentarioTransporte(evaluacionActualizada.getComentarioTransporte());
        }
        if (evaluacionActualizada.getComentarioHotel() != null) {
            evaluacionExistente.setComentarioHotel(evaluacionActualizada.getComentarioHotel());
        }
        if (evaluacionActualizada.getRecomendaciones() != null) {
            evaluacionExistente.setRecomendaciones(evaluacionActualizada.getRecomendaciones());
        }
        return (EvaluacionServicio)this.evaluacionRepository.save((Object)evaluacionExistente);
    }

    @Transactional
    public EvaluacionServicio toggleEstado(Long id) {
        log.info("Cambiando estado de evaluaci\u00f3n ID: {}", (Object)id);
        EvaluacionServicio evaluacion = (EvaluacionServicio)this.evaluacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Evaluaci\u00f3n no encontrada"));
        evaluacion.setEstado(Boolean.valueOf(evaluacion.getEstado() == false));
        return (EvaluacionServicio)this.evaluacionRepository.save((Object)evaluacion);
    }

    @Transactional
    public void delete(Long id) {
        log.info("Eliminando evaluaci\u00f3n ID: {}", (Object)id);
        EvaluacionServicio evaluacion = (EvaluacionServicio)this.evaluacionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Evaluaci\u00f3n no encontrada"));
        this.evaluacionRepository.delete((Object)evaluacion);
    }

    @Transactional(readOnly=true)
    public Object[] getEstadisticasByServicio(Long servicioId) {
        return this.evaluacionRepository.getEstadisticasByServicio(servicioId);
    }

    @Transactional(readOnly=true)
    public Object[] getEstadisticasByPaquete(Long paqueteId) {
        return this.evaluacionRepository.getEstadisticasByPaquete(paqueteId);
    }

    @Transactional(readOnly=true)
    public boolean puedeEvaluarReserva(Long reservaId) {
        Optional reservaOpt = this.reservaRepository.findById((Object)reservaId);
        if (reservaOpt.isEmpty()) {
            return false;
        }
        Reserva reserva = (Reserva)reservaOpt.get();
        return reserva.getEstado() == Reserva.EstadoReserva.Completada && !this.evaluacionRepository.existsByReservaId(reservaId);
    }

    public EvaluacionServicioService(EvaluacionServicioRepository evaluacionRepository, ReservaRepository reservaRepository) {
        this.evaluacionRepository = evaluacionRepository;
        this.reservaRepository = reservaRepository;
    }
}

