/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.VoucherRepository;
import com.sistema.turistico.security.TenantContext;
import com.sistema.turistico.service.ReservaService;
import com.sistema.turistico.service.VoucherService;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VoucherService {
    private static final Logger log = LoggerFactory.getLogger(VoucherService.class);
    private final VoucherRepository voucherRepository;
    private final ReservaService reservaService;

    @Transactional(readOnly=true)
    public VoucherPageResult listarVouchers(Long empresaId, String busqueda, Voucher.EstadoVoucher estado, int page, int size) {
        int pagina = Math.max(page, 1);
        int tamanio = Math.max(size, 1);
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para listar vouchers");
        String termino = this.normalizarTexto(busqueda);
        List<Voucher> filtrados = this.voucherRepository.findByReserva_Empresa_IdEmpresa(empresaFiltrada).stream().filter(arg_0 -> this.puedeVerVoucher(arg_0)).filter(v -> estado == null || v.getEstado() == estado).filter(v -> this.coincideBusqueda(v, termino)).sorted(Comparator.comparing(Voucher::getCreatedAt, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).toList();
        int total = filtrados.size();
        int startIndex = Math.min((pagina - 1) * tamanio, total);
        int endIndex = Math.min(startIndex + tamanio, total);
        List<VoucherResponse> data = filtrados.subList(startIndex, endIndex).stream().map(arg_0 -> ((ReservaService)this.reservaService).toVoucherResponse(arg_0)).toList();
        return new VoucherPageResult(data, total, pagina, tamanio);
    }

    @Transactional(readOnly=true)
    public VoucherResponse obtenerPorCodigoQr(String codigoQr) {
        Voucher voucher = (Voucher)this.voucherRepository.findByCodigoQr(codigoQr).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado"));
        return this.reservaService.toVoucherResponse(voucher);
    }

    public VoucherResponse actualizarEstado(String codigoQr, String estadoSolicitado) {
        Voucher voucher = this.obtenerVoucherAutorizado(codigoQr);
        Voucher.EstadoVoucher nuevoEstado = this.parseEstado(estadoSolicitado);
        if (voucher.getEstado() == nuevoEstado) {
            throw new IllegalArgumentException("El estado ya es " + String.valueOf(nuevoEstado));
        }
        this.validarCambioEstado(voucher.getEstado(), nuevoEstado);
        voucher.setEstado(nuevoEstado);
        Voucher actualizado = (Voucher)this.voucherRepository.save((Object)voucher);
        log.info("Voucher {} actualizado a estado {}", (Object)codigoQr, (Object)nuevoEstado);
        return this.reservaService.toVoucherResponse(actualizado);
    }

    public VoucherResponse cancelar(String codigoQr) {
        Voucher voucher = this.obtenerVoucherAutorizado(codigoQr);
        if (voucher.getEstado() == Voucher.EstadoVoucher.Usado) {
            throw new IllegalArgumentException("No se puede cancelar un voucher usado");
        }
        if (voucher.getEstado() == Voucher.EstadoVoucher.Expirado) {
            throw new IllegalArgumentException("No se puede cancelar un voucher expirado");
        }
        if (voucher.getEstado() == Voucher.EstadoVoucher.Cancelado) {
            throw new IllegalArgumentException("El voucher ya est\u00e1 cancelado");
        }
        voucher.setEstado(Voucher.EstadoVoucher.Cancelado);
        Voucher cancelado = (Voucher)this.voucherRepository.save((Object)voucher);
        log.info("Voucher {} cancelado", (Object)codigoQr);
        return this.reservaService.toVoucherResponse(cancelado);
    }

    private Voucher obtenerVoucherAutorizado(String codigoQr) {
        Long empresaVoucher;
        Long empresaActual;
        Voucher voucher = (Voucher)this.voucherRepository.findByCodigoQr(codigoQr).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado"));
        if (!this.esSuperAdmin() && !(empresaActual = TenantContext.requireEmpresaId()).equals(empresaVoucher = this.obtenerEmpresaDelVoucher(voucher))) {
            throw new IllegalArgumentException("El voucher no pertenece a la empresa actual");
        }
        return voucher;
    }

    private Long obtenerEmpresaDelVoucher(Voucher voucher) {
        Reserva reserva = voucher.getReserva();
        if (reserva == null || reserva.getEmpresa() == null) {
            return null;
        }
        return reserva.getEmpresa().getIdEmpresa();
    }

    private boolean coincideBusqueda(Voucher voucher, String termino) {
        if (termino == null) {
            return true;
        }
        String lower = termino.toLowerCase(Locale.ROOT);
        if (voucher.getCodigoQr() != null && voucher.getCodigoQr().toLowerCase(Locale.ROOT).contains(lower)) {
            return true;
        }
        Reserva reserva = voucher.getReserva();
        if (reserva != null) {
            String nombreCompleto;
            if (reserva.getCodigoReserva() != null && reserva.getCodigoReserva().toLowerCase(Locale.ROOT).contains(lower)) {
                return true;
            }
            Cliente cliente = reserva.getCliente();
            if (cliente != null && !(nombreCompleto = Stream.of(cliente.getNombre(), cliente.getApellido()).map(arg_0 -> this.normalizarTexto(arg_0)).filter(Objects::nonNull).reduce((a, b) -> a + " " + b).orElse("")).isBlank() && nombreCompleto.toLowerCase(Locale.ROOT).contains(lower)) {
                return true;
            }
        }
        return false;
    }

    private Voucher.EstadoVoucher parseEstado(String estadoSolicitado) {
        if (estadoSolicitado == null || estadoSolicitado.isBlank()) {
            throw new IllegalArgumentException("Debe proporcionar el estado para actualizar");
        }
        String valor = estadoSolicitado.trim();
        if ("Canjeado".equalsIgnoreCase(valor)) {
            valor = Voucher.EstadoVoucher.Usado.name();
        }
        try {
            return Voucher.EstadoVoucher.valueOf((String)valor);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Estado no v\u00e1lido: " + estadoSolicitado);
        }
    }

    private void validarCambioEstado(Voucher.EstadoVoucher estadoActual, Voucher.EstadoVoucher estadoNuevo) {
        if (estadoActual == estadoNuevo) {
            return;
        }
        switch (1.$SwitchMap$com$sistema$turistico$entity$Voucher$EstadoVoucher[estadoActual.ordinal()]) {
            case 1: {
                if (estadoNuevo != Voucher.EstadoVoucher.Usado && estadoNuevo != Voucher.EstadoVoucher.Expirado && estadoNuevo != Voucher.EstadoVoucher.Cancelado) break;
                return;
            }
            case 2: {
                throw new IllegalArgumentException("No se puede cambiar el estado de un voucher usado");
            }
            case 3: {
                throw new IllegalArgumentException("No se puede cambiar el estado de un voucher expirado");
            }
            case 4: {
                throw new IllegalArgumentException("No se puede cambiar el estado de un voucher cancelado");
            }
        }
        throw new IllegalArgumentException("Cambio de estado no permitido de " + String.valueOf(estadoActual) + " a " + String.valueOf(estadoNuevo));
    }

    private boolean puedeVerVoucher(Voucher voucher) {
        if (TenantContext.isSuperAdmin()) {
            return true;
        }
        Long empresaActual = TenantContext.requireEmpresaId();
        Long empresaVoucher = this.obtenerEmpresaDelVoucher(voucher);
        return empresaActual.equals(empresaVoucher);
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private String normalizarTexto(String valor) {
        if (valor == null) {
            return null;
        }
        String trimmed = valor.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    public VoucherService(VoucherRepository voucherRepository, ReservaService reservaService) {
        this.voucherRepository = voucherRepository;
        this.reservaService = reservaService;
    }
}

