/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.config;

import java.util.Arrays;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig
implements WebMvcConfigurer {
    @Value(value="${app.config.cors.allowed-origins}")
    private String allowedOrigins;
    @Value(value="${app.config.cors.allowed-methods}")
    private String allowedMethods;
    @Value(value="${app.config.cors.allowed-headers}")
    private String allowedHeaders;
    @Value(value="${app.config.cors.allow-credentials}")
    private boolean allowCredentials;

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(this.allowedOrigins.split(",")).allowedMethods(this.allowedMethods.split(",")).allowedHeaders(new String[]{this.allowedHeaders}).allowCredentials(this.allowCredentials).maxAge(3600L);
    }

    @Bean
    @Primary
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList(this.allowedOrigins.split(",")));
        configuration.setAllowedMethods(Arrays.asList(this.allowedMethods.split(",")));
        configuration.setAllowedHeaders(Arrays.asList(this.allowedHeaders));
        configuration.setAllowCredentials(Boolean.valueOf(this.allowCredentials));
        configuration.setMaxAge(Long.valueOf(3600L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

