/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.config;

import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="jwt")
public class JwtConfig {
    private String secret;
    private long expiration = 86400000L;
    private String issuer = "sistema-turistico";

    public SecretKey getSecretKey() {
        return Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8));
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public long getExpiration() {
        return this.expiration;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

