/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.service.PersonalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personal"})
@Tag(name="Personal", description="Gesti\u00f3n del personal de la empresa")
public class PersonalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonalController.class);
    private final PersonalService personalService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Crear personal", description="Registra un nuevo miembro del personal")
    public ResponseEntity<Map<String, Object>> crearPersonal(@Valid @RequestBody Personal personal) {
        try {
            Personal nuevoPersonal = this.personalService.crearPersonal(personal);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal creado exitosamente");
            response.put("data", nuevoPersonal);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear personal: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al crear personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Obtener personal", description="Obtiene la informaci\u00f3n de un miembro del personal espec\u00edfico")
    public ResponseEntity<Map<String, Object>> obtenerPersonal(@PathVariable Long id) {
        try {
            Personal personal = (Personal)this.personalService.obtenerPersonalPorId(id).orElseThrow(() -> new IllegalArgumentException("Personal no encontrado"));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal obtenido exitosamente");
            response.put("data", personal);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Personal no encontrado: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar personal", description="Lista el personal con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarPersonal(@RequestParam(required=false) Long empresaId, @RequestParam(required=false) Long sucursalId, @RequestParam(required=false) Personal.Cargo cargo, @RequestParam(required=false) Boolean estado, @RequestParam(required=false) String busqueda, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        try {
            List personal = this.personalService.listarPersonalConFiltros(empresaId, sucursalId, cargo, estado, busqueda);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal obtenido exitosamente");
            response.put("data", personal);
            response.put("total", personal.size());
            response.put("page", page);
            response.put("size", size);
            response.put("totalPages", (int)Math.ceil((double)personal.size() / (double)size));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Actualizar personal", description="Actualiza la informaci\u00f3n de un miembro del personal")
    public ResponseEntity<Map<String, Object>> actualizarPersonal(@PathVariable Long id, @Valid @RequestBody Personal personal) {
        try {
            Personal personalActualizado = this.personalService.actualizarPersonal(id, personal);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal actualizado exitosamente");
            response.put("data", personalActualizado);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar personal: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al actualizar personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Desactivar personal", description="Desactiva un miembro del personal")
    public ResponseEntity<Map<String, Object>> eliminarPersonal(@PathVariable Long id) {
        try {
            this.personalService.eliminarPersonal(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal desactivado exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al desactivar personal: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al desactivar personal", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/empresa/{empresaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar personal por empresa", description="Obtiene todo el personal de una empresa espec\u00edfica")
    public ResponseEntity<Map<String, Object>> listarPersonalPorEmpresa(@PathVariable Long empresaId) {
        try {
            List personal = this.personalService.listarPersonalPorEmpresa(empresaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal obtenido exitosamente");
            response.put("data", personal);
            response.put("total", personal.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar personal por empresa", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/cargo/{cargo}/empresa/{empresaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR', 'GERENTE')")
    @Operation(summary="Listar personal por cargo", description="Obtiene el personal de un cargo espec\u00edfico en una empresa")
    public ResponseEntity<Map<String, Object>> listarPersonalPorCargo(@PathVariable Personal.Cargo cargo, @PathVariable Long empresaId) {
        try {
            List personal = this.personalService.obtenerPersonalPorCargo(empresaId, cargo);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Personal obtenido exitosamente");
            response.put("data", personal);
            response.put("total", personal.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar personal por cargo", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @Generated
    public PersonalController(PersonalService personalService) {
        this.personalService = personalService;
    }
}

