/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.RolRequest;
import com.sistema.turistico.dto.RolResponse;
import com.sistema.turistico.entity.Rol;
import com.sistema.turistico.service.RolService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roles"})
@Tag(name="Roles", description="Endpoints para gesti\u00f3n de roles")
public class RolController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RolController.class);
    private final RolService rolService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Crear rol", description="Crea un nuevo rol")
    public ResponseEntity<Map<String, Object>> crearRol(@Valid @RequestBody RolRequest request) {
        try {
            log.info("Solicitando creaci\u00f3n de rol");
            Rol rol = this.rolService.crear(request);
            RolResponse data = this.rolService.toResponse(rol);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Rol creado exitosamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear rol: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al crear rol", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Listar roles", description="Obtiene la lista de roles")
    public ResponseEntity<Map<String, Object>> listarRoles(@RequestParam(required=false) String busqueda, @RequestParam(required=false) Integer estado) {
        try {
            log.info("Listando roles con filtros: busqueda={}, estado={}", (Object)busqueda, (Object)estado);
            List roles = this.rolService.listar(busqueda, estado);
            List<RolResponse> data = roles.stream().map(arg_0 -> ((RolService)this.rolService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Roles obtenidos exitosamente");
            response.put("data", data);
            response.put("total", data.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar roles", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Obtener rol", description="Obtiene un rol por su identificador")
    public ResponseEntity<Map<String, Object>> obtenerRol(@PathVariable Long id) {
        try {
            log.info("Obteniendo rol {}", (Object)id);
            Rol rol = this.rolService.obtenerPorId(id);
            RolResponse data = this.rolService.toResponse(rol);
            return ResponseEntity.ok(Map.of("success", true, "message", "Rol obtenido exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Rol no encontrado: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener rol {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Actualizar rol", description="Actualiza los datos de un rol")
    public ResponseEntity<Map<String, Object>> actualizarRol(@PathVariable Long id, @Valid @RequestBody RolRequest request) {
        try {
            log.info("Actualizando rol {}", (Object)id);
            Rol rol = this.rolService.actualizar(id, request);
            RolResponse data = this.rolService.toResponse(rol);
            return ResponseEntity.ok(Map.of("success", true, "message", "Rol actualizado exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar rol: {}", (Object)ex.getMessage());
            if ("Rol no encontrado".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al actualizar rol {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Eliminar rol", description="Realiza un borrado l\u00f3gico de un rol")
    public ResponseEntity<Map<String, Object>> eliminarRol(@PathVariable Long id) {
        try {
            log.info("Eliminando rol {}", (Object)id);
            this.rolService.eliminar(id);
            return ResponseEntity.ok(Map.of("success", true, "message", "Rol eliminado exitosamente"));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar rol: {}", (Object)ex.getMessage());
            if ("Rol no encontrado".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al eliminar rol {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @Generated
    public RolController(RolService rolService) {
        this.rolService = rolService;
    }
}

