/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.UsuarioRequest;
import com.sistema.turistico.dto.UsuarioResponse;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.service.UsuarioCrudService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/usuarios"})
@Tag(name="Usuarios", description="Endpoints para gesti\u00f3n de usuarios")
public class UsuarioController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsuarioController.class);
    private final UsuarioCrudService usuarioService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Crear usuario", description="Crea un nuevo usuario")
    public ResponseEntity<Map<String, Object>> crearUsuario(@Valid @RequestBody UsuarioRequest request) {
        try {
            log.info("Solicitando creaci\u00f3n de usuario");
            Usuario usuario = this.usuarioService.crear(request);
            UsuarioResponse data = this.usuarioService.toResponse(usuario);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Usuario creado exitosamente");
            response.put("data", data);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear usuario: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al crear usuario", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Listar usuarios", description="Obtiene la lista de usuarios")
    public ResponseEntity<Map<String, Object>> listarUsuarios(@RequestParam(required=false) String busqueda, @RequestParam(required=false) Integer estado, @RequestParam(required=false) Long empresaId, @RequestParam(required=false) Long rolId) {
        try {
            log.info("Listando usuarios con filtros: busqueda={}, estado={}, empresaId={}, rolId={}", new Object[]{busqueda, estado, empresaId, rolId});
            List usuarios = this.usuarioService.listar(busqueda, estado, empresaId, rolId);
            List<UsuarioResponse> data = usuarios.stream().map(arg_0 -> ((UsuarioCrudService)this.usuarioService).toResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Usuarios obtenidos exitosamente");
            response.put("data", data);
            response.put("total", data.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar usuarios", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Obtener usuario", description="Obtiene un usuario por su identificador")
    public ResponseEntity<Map<String, Object>> obtenerUsuario(@PathVariable Long id) {
        try {
            log.info("Obteniendo usuario {}", (Object)id);
            Usuario usuario = this.usuarioService.obtenerPorId(id);
            UsuarioResponse data = this.usuarioService.toResponse(usuario);
            return ResponseEntity.ok(Map.of("success", true, "message", "Usuario obtenido exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Usuario no encontrado: {}", (Object)ex.getMessage());
            return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al obtener usuario {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Actualizar usuario", description="Actualiza los datos de un usuario")
    public ResponseEntity<Map<String, Object>> actualizarUsuario(@PathVariable Long id, @Valid @RequestBody UsuarioRequest request) {
        try {
            log.info("Actualizando usuario {}", (Object)id);
            Usuario usuario = this.usuarioService.actualizar(id, request);
            UsuarioResponse data = this.usuarioService.toResponse(usuario);
            return ResponseEntity.ok(Map.of("success", true, "message", "Usuario actualizado exitosamente", "data", data));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar usuario: {}", (Object)ex.getMessage());
            if ("Usuario no encontrado".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al actualizar usuario {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('SUPERADMINISTRADOR','ADMINISTRADOR','GERENTE')")
    @Operation(summary="Eliminar usuario", description="Realiza un borrado l\u00f3gico de un usuario")
    public ResponseEntity<Map<String, Object>> eliminarUsuario(@PathVariable Long id) {
        try {
            log.info("Eliminando usuario {}", (Object)id);
            this.usuarioService.eliminar(id);
            return ResponseEntity.ok(Map.of("success", true, "message", "Usuario eliminado exitosamente"));
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar usuario: {}", (Object)ex.getMessage());
            if ("Usuario no encontrado".equalsIgnoreCase(ex.getMessage())) {
                return ResponseEntity.status((int)404).body(Map.of("success", false, "message", ex.getMessage()));
            }
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error interno al eliminar usuario {}", (Object)id, (Object)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @Generated
    public UsuarioController(UsuarioCrudService usuarioService) {
        this.usuarioService = usuarioService;
    }
}

