/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ServicioTuristico;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Date;
import lombok.Generated;

@Entity
@Table(name="evaluaciones_servicios", indexes={@Index(name="idx_calificacion", columnList="calificacion_general"), @Index(name="idx_fecha_eval", columnList="fecha_evaluacion")})
public class EvaluacionServicio {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_evaluacion")
    private Long idEvaluacion;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva", nullable=false)
    private Reserva reserva;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_cliente", nullable=false)
    private Cliente cliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_servicio")
    private ServicioTuristico servicio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_paquete")
    private PaqueteTuristico paquete;
    @Min(value=1L)
    @Max(value=5L)
    @Column(name="calificacion_general")
    private @Min(value=1L) @Max(value=5L) Integer calificacionGeneral;
    @Min(value=1L)
    @Max(value=5L)
    @Column(name="calificacion_guia")
    private @Min(value=1L) @Max(value=5L) Integer calificacionGuia;
    @Min(value=1L)
    @Max(value=5L)
    @Column(name="calificacion_transporte")
    private @Min(value=1L) @Max(value=5L) Integer calificacionTransporte;
    @Min(value=1L)
    @Max(value=5L)
    @Column(name="calificacion_hotel")
    private @Min(value=1L) @Max(value=5L) Integer calificacionHotel;
    @Column(name="comentario_general", columnDefinition="TEXT")
    private String comentarioGeneral;
    @Column(name="comentario_guia", columnDefinition="TEXT")
    private String comentarioGuia;
    @Column(name="comentario_transporte", columnDefinition="TEXT")
    private String comentarioTransporte;
    @Column(name="comentario_hotel", columnDefinition="TEXT")
    private String comentarioHotel;
    @Column(name="recomendaciones", columnDefinition="TEXT")
    private String recomendaciones;
    @Column(name="fecha_evaluacion", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fechaEvaluacion;
    @Column(name="estado", nullable=false)
    private Boolean estado = true;

    @PrePersist
    protected void onCreate() {
        if (this.fechaEvaluacion == null) {
            this.fechaEvaluacion = new Date();
        }
    }

    public Double getCalificacionPromedio() {
        int count = 0;
        int sum = 0;
        if (this.calificacionGeneral != null) {
            sum += this.calificacionGeneral.intValue();
            ++count;
        }
        if (this.calificacionGuia != null) {
            sum += this.calificacionGuia.intValue();
            ++count;
        }
        if (this.calificacionTransporte != null) {
            sum += this.calificacionTransporte.intValue();
            ++count;
        }
        if (this.calificacionHotel != null) {
            sum += this.calificacionHotel.intValue();
            ++count;
        }
        return count > 0 ? Double.valueOf((double)sum / (double)count) : null;
    }

    public boolean isVisible() {
        return this.estado != null && this.estado != false;
    }

    @Generated
    public Long getIdEvaluacion() {
        return this.idEvaluacion;
    }

    @Generated
    public Reserva getReserva() {
        return this.reserva;
    }

    @Generated
    public Cliente getCliente() {
        return this.cliente;
    }

    @Generated
    public ServicioTuristico getServicio() {
        return this.servicio;
    }

    @Generated
    public PaqueteTuristico getPaquete() {
        return this.paquete;
    }

    @Generated
    public Integer getCalificacionGeneral() {
        return this.calificacionGeneral;
    }

    @Generated
    public Integer getCalificacionGuia() {
        return this.calificacionGuia;
    }

    @Generated
    public Integer getCalificacionTransporte() {
        return this.calificacionTransporte;
    }

    @Generated
    public Integer getCalificacionHotel() {
        return this.calificacionHotel;
    }

    @Generated
    public String getComentarioGeneral() {
        return this.comentarioGeneral;
    }

    @Generated
    public String getComentarioGuia() {
        return this.comentarioGuia;
    }

    @Generated
    public String getComentarioTransporte() {
        return this.comentarioTransporte;
    }

    @Generated
    public String getComentarioHotel() {
        return this.comentarioHotel;
    }

    @Generated
    public String getRecomendaciones() {
        return this.recomendaciones;
    }

    @Generated
    public Date getFechaEvaluacion() {
        return this.fechaEvaluacion;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public void setIdEvaluacion(Long idEvaluacion) {
        this.idEvaluacion = idEvaluacion;
    }

    @Generated
    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    @Generated
    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Generated
    public void setServicio(ServicioTuristico servicio) {
        this.servicio = servicio;
    }

    @Generated
    public void setPaquete(PaqueteTuristico paquete) {
        this.paquete = paquete;
    }

    @Generated
    public void setCalificacionGeneral(Integer calificacionGeneral) {
        this.calificacionGeneral = calificacionGeneral;
    }

    @Generated
    public void setCalificacionGuia(Integer calificacionGuia) {
        this.calificacionGuia = calificacionGuia;
    }

    @Generated
    public void setCalificacionTransporte(Integer calificacionTransporte) {
        this.calificacionTransporte = calificacionTransporte;
    }

    @Generated
    public void setCalificacionHotel(Integer calificacionHotel) {
        this.calificacionHotel = calificacionHotel;
    }

    @Generated
    public void setComentarioGeneral(String comentarioGeneral) {
        this.comentarioGeneral = comentarioGeneral;
    }

    @Generated
    public void setComentarioGuia(String comentarioGuia) {
        this.comentarioGuia = comentarioGuia;
    }

    @Generated
    public void setComentarioTransporte(String comentarioTransporte) {
        this.comentarioTransporte = comentarioTransporte;
    }

    @Generated
    public void setComentarioHotel(String comentarioHotel) {
        this.comentarioHotel = comentarioHotel;
    }

    @Generated
    public void setRecomendaciones(String recomendaciones) {
        this.recomendaciones = recomendaciones;
    }

    @Generated
    public void setFechaEvaluacion(Date fechaEvaluacion) {
        this.fechaEvaluacion = fechaEvaluacion;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluacionServicio)) {
            return false;
        }
        EvaluacionServicio other = (EvaluacionServicio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idEvaluacion = this.getIdEvaluacion();
        Long other$idEvaluacion = other.getIdEvaluacion();
        if (this$idEvaluacion == null ? other$idEvaluacion != null : !((Object)this$idEvaluacion).equals(other$idEvaluacion)) {
            return false;
        }
        Integer this$calificacionGeneral = this.getCalificacionGeneral();
        Integer other$calificacionGeneral = other.getCalificacionGeneral();
        if (this$calificacionGeneral == null ? other$calificacionGeneral != null : !((Object)this$calificacionGeneral).equals(other$calificacionGeneral)) {
            return false;
        }
        Integer this$calificacionGuia = this.getCalificacionGuia();
        Integer other$calificacionGuia = other.getCalificacionGuia();
        if (this$calificacionGuia == null ? other$calificacionGuia != null : !((Object)this$calificacionGuia).equals(other$calificacionGuia)) {
            return false;
        }
        Integer this$calificacionTransporte = this.getCalificacionTransporte();
        Integer other$calificacionTransporte = other.getCalificacionTransporte();
        if (this$calificacionTransporte == null ? other$calificacionTransporte != null : !((Object)this$calificacionTransporte).equals(other$calificacionTransporte)) {
            return false;
        }
        Integer this$calificacionHotel = this.getCalificacionHotel();
        Integer other$calificacionHotel = other.getCalificacionHotel();
        if (this$calificacionHotel == null ? other$calificacionHotel != null : !((Object)this$calificacionHotel).equals(other$calificacionHotel)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Reserva this$reserva = this.getReserva();
        Reserva other$reserva = other.getReserva();
        if (this$reserva == null ? other$reserva != null : !this$reserva.equals(other$reserva)) {
            return false;
        }
        Cliente this$cliente = this.getCliente();
        Cliente other$cliente = other.getCliente();
        if (this$cliente == null ? other$cliente != null : !this$cliente.equals(other$cliente)) {
            return false;
        }
        ServicioTuristico this$servicio = this.getServicio();
        ServicioTuristico other$servicio = other.getServicio();
        if (this$servicio == null ? other$servicio != null : !this$servicio.equals(other$servicio)) {
            return false;
        }
        PaqueteTuristico this$paquete = this.getPaquete();
        PaqueteTuristico other$paquete = other.getPaquete();
        if (this$paquete == null ? other$paquete != null : !this$paquete.equals(other$paquete)) {
            return false;
        }
        String this$comentarioGeneral = this.getComentarioGeneral();
        String other$comentarioGeneral = other.getComentarioGeneral();
        if (this$comentarioGeneral == null ? other$comentarioGeneral != null : !this$comentarioGeneral.equals(other$comentarioGeneral)) {
            return false;
        }
        String this$comentarioGuia = this.getComentarioGuia();
        String other$comentarioGuia = other.getComentarioGuia();
        if (this$comentarioGuia == null ? other$comentarioGuia != null : !this$comentarioGuia.equals(other$comentarioGuia)) {
            return false;
        }
        String this$comentarioTransporte = this.getComentarioTransporte();
        String other$comentarioTransporte = other.getComentarioTransporte();
        if (this$comentarioTransporte == null ? other$comentarioTransporte != null : !this$comentarioTransporte.equals(other$comentarioTransporte)) {
            return false;
        }
        String this$comentarioHotel = this.getComentarioHotel();
        String other$comentarioHotel = other.getComentarioHotel();
        if (this$comentarioHotel == null ? other$comentarioHotel != null : !this$comentarioHotel.equals(other$comentarioHotel)) {
            return false;
        }
        String this$recomendaciones = this.getRecomendaciones();
        String other$recomendaciones = other.getRecomendaciones();
        if (this$recomendaciones == null ? other$recomendaciones != null : !this$recomendaciones.equals(other$recomendaciones)) {
            return false;
        }
        Date this$fechaEvaluacion = this.getFechaEvaluacion();
        Date other$fechaEvaluacion = other.getFechaEvaluacion();
        return !(this$fechaEvaluacion == null ? other$fechaEvaluacion != null : !((Object)this$fechaEvaluacion).equals(other$fechaEvaluacion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EvaluacionServicio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEvaluacion = this.getIdEvaluacion();
        result = result * 59 + ($idEvaluacion == null ? 43 : ((Object)$idEvaluacion).hashCode());
        Integer $calificacionGeneral = this.getCalificacionGeneral();
        result = result * 59 + ($calificacionGeneral == null ? 43 : ((Object)$calificacionGeneral).hashCode());
        Integer $calificacionGuia = this.getCalificacionGuia();
        result = result * 59 + ($calificacionGuia == null ? 43 : ((Object)$calificacionGuia).hashCode());
        Integer $calificacionTransporte = this.getCalificacionTransporte();
        result = result * 59 + ($calificacionTransporte == null ? 43 : ((Object)$calificacionTransporte).hashCode());
        Integer $calificacionHotel = this.getCalificacionHotel();
        result = result * 59 + ($calificacionHotel == null ? 43 : ((Object)$calificacionHotel).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Reserva $reserva = this.getReserva();
        result = result * 59 + ($reserva == null ? 43 : $reserva.hashCode());
        Cliente $cliente = this.getCliente();
        result = result * 59 + ($cliente == null ? 43 : $cliente.hashCode());
        ServicioTuristico $servicio = this.getServicio();
        result = result * 59 + ($servicio == null ? 43 : $servicio.hashCode());
        PaqueteTuristico $paquete = this.getPaquete();
        result = result * 59 + ($paquete == null ? 43 : $paquete.hashCode());
        String $comentarioGeneral = this.getComentarioGeneral();
        result = result * 59 + ($comentarioGeneral == null ? 43 : $comentarioGeneral.hashCode());
        String $comentarioGuia = this.getComentarioGuia();
        result = result * 59 + ($comentarioGuia == null ? 43 : $comentarioGuia.hashCode());
        String $comentarioTransporte = this.getComentarioTransporte();
        result = result * 59 + ($comentarioTransporte == null ? 43 : $comentarioTransporte.hashCode());
        String $comentarioHotel = this.getComentarioHotel();
        result = result * 59 + ($comentarioHotel == null ? 43 : $comentarioHotel.hashCode());
        String $recomendaciones = this.getRecomendaciones();
        result = result * 59 + ($recomendaciones == null ? 43 : $recomendaciones.hashCode());
        Date $fechaEvaluacion = this.getFechaEvaluacion();
        result = result * 59 + ($fechaEvaluacion == null ? 43 : ((Object)$fechaEvaluacion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EvaluacionServicio(idEvaluacion=" + String.valueOf(this.getIdEvaluacion()) + ", reserva=" + String.valueOf(this.getReserva()) + ", cliente=" + String.valueOf(this.getCliente()) + ", servicio=" + String.valueOf(this.getServicio()) + ", paquete=" + String.valueOf(this.getPaquete()) + ", calificacionGeneral=" + String.valueOf(this.getCalificacionGeneral()) + ", calificacionGuia=" + String.valueOf(this.getCalificacionGuia()) + ", calificacionTransporte=" + String.valueOf(this.getCalificacionTransporte()) + ", calificacionHotel=" + String.valueOf(this.getCalificacionHotel()) + ", comentarioGeneral=" + this.getComentarioGeneral() + ", comentarioGuia=" + this.getComentarioGuia() + ", comentarioTransporte=" + this.getComentarioTransporte() + ", comentarioHotel=" + this.getComentarioHotel() + ", recomendaciones=" + this.getRecomendaciones() + ", fechaEvaluacion=" + String.valueOf(this.getFechaEvaluacion()) + ", estado=" + String.valueOf(this.getEstado()) + ")";
    }

    @Generated
    public EvaluacionServicio() {
    }

    @Generated
    public EvaluacionServicio(Long idEvaluacion, Reserva reserva, Cliente cliente, ServicioTuristico servicio, PaqueteTuristico paquete, Integer calificacionGeneral, Integer calificacionGuia, Integer calificacionTransporte, Integer calificacionHotel, String comentarioGeneral, String comentarioGuia, String comentarioTransporte, String comentarioHotel, String recomendaciones, Date fechaEvaluacion, Boolean estado) {
        this.idEvaluacion = idEvaluacion;
        this.reserva = reserva;
        this.cliente = cliente;
        this.servicio = servicio;
        this.paquete = paquete;
        this.calificacionGeneral = calificacionGeneral;
        this.calificacionGuia = calificacionGuia;
        this.calificacionTransporte = calificacionTransporte;
        this.calificacionHotel = calificacionHotel;
        this.comentarioGeneral = comentarioGeneral;
        this.comentarioGuia = comentarioGuia;
        this.comentarioTransporte = comentarioTransporte;
        this.comentarioHotel = comentarioHotel;
        this.recomendaciones = recomendaciones;
        this.fechaEvaluacion = fechaEvaluacion;
        this.estado = estado;
    }
}

