/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.PaqueteServicio;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.entity.Sucursal;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="paquetes_turisticos")
public class PaqueteTuristico {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_paquete")
    private Long idPaquete;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @NotBlank(message="El nombre del paquete es obligatorio")
    @Size(max=255, message="El nombre no puede exceder 255 caracteres")
    @Column(name="nombre_paquete", nullable=false)
    private @NotBlank(message="El nombre del paquete es obligatorio") @Size(max=255, message="El nombre no puede exceder 255 caracteres") String nombrePaquete;
    @Size(max=1000, message="La descripci\u00f3n no puede exceder 1000 caracteres")
    @Column(columnDefinition="TEXT")
    private @Size(max=1000, message="La descripci\u00f3n no puede exceder 1000 caracteres") String descripcion;
    @NotNull(message="El precio total es obligatorio")
    @DecimalMin(value="0.01", message="El precio total debe ser mayor a 0")
    @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="precio_total", nullable=false, precision=10, scale=2)
    private @NotNull(message="El precio total es obligatorio") @DecimalMin(value="0.01", message="El precio total debe ser mayor a 0") @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal precioTotal;
    @Min(value=1L, message="La duraci\u00f3n debe ser al menos 1 d\u00eda")
    @Column(name="duracion_dias")
    private @Min(value=1L, message="La duraci\u00f3n debe ser al menos 1 d\u00eda") Integer duracionDias;
    @Column(columnDefinition="TINYINT(1) DEFAULT 0")
    private Boolean promocion = false;
    @DecimalMin(value="0.00", message="El descuento no puede ser negativo")
    @DecimalMax(value="100.00", message="El descuento no puede exceder 100%")
    @Digits(integer=5, fraction=2, message="El descuento debe tener m\u00e1ximo 5 d\u00edgitos enteros y 2 decimales")
    @Column(precision=5, scale=2, columnDefinition="DECIMAL(5,2) DEFAULT 0.00")
    private @DecimalMin(value="0.00", message="El descuento no puede ser negativo") @DecimalMax(value="100.00", message="El descuento no puede exceder 100%") @Digits(integer=5, fraction=2, message="El descuento debe tener m\u00e1ximo 5 d\u00edgitos enteros y 2 decimales") BigDecimal descuento = BigDecimal.ZERO;
    @NotNull(message="El estado es obligatorio")
    @Column(columnDefinition="TINYINT(1) DEFAULT 1 COMMENT '1=Activo, 0=Inactivo'")
    private @NotNull(message="El estado es obligatorio") Boolean estado = true;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;
    @OneToMany(mappedBy="paquete", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<PaqueteServicio> serviciosIncluidos = new ArrayList();

    public PaqueteTuristico(Empresa empresa, String nombrePaquete, String descripcion, BigDecimal precioTotal, Integer duracionDias) {
        this.empresa = empresa;
        this.nombrePaquete = nombrePaquete;
        this.descripcion = descripcion;
        this.precioTotal = precioTotal;
        this.duracionDias = duracionDias;
        this.estado = true;
        this.promocion = false;
        this.descuento = BigDecimal.ZERO;
    }

    public boolean isActivo() {
        return this.estado != false && this.deletedAt == null;
    }

    public BigDecimal getPrecioFinal() {
        if (this.descuento != null && this.descuento.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal descuentoMonto = this.precioTotal.multiply(this.descuento).divide(BigDecimal.valueOf(100L));
            return this.precioTotal.subtract(descuentoMonto);
        }
        return this.precioTotal;
    }

    public int getNumeroServicios() {
        return this.serviciosIncluidos != null ? this.serviciosIncluidos.size() : 0;
    }

    public boolean tieneServicios() {
        return this.serviciosIncluidos != null && !this.serviciosIncluidos.isEmpty();
    }

    public void agregarServicio(ServicioTuristico servicio, Integer orden) {
        PaqueteServicio paqueteServicio = new PaqueteServicio(this, servicio, orden);
        this.serviciosIncluidos.add(paqueteServicio);
    }

    public void removerServicio(ServicioTuristico servicio) {
        this.serviciosIncluidos.removeIf(ps -> ps.getServicio().equals((Object)servicio));
    }

    public boolean estaDisponible() {
        return this.isActivo() && this.tieneServicios();
    }

    @PrePersist
    protected void onCreate() {
        if (this.createdAt == null) {
            this.createdAt = LocalDateTime.now();
        }
        if (this.updatedAt == null) {
            this.updatedAt = LocalDateTime.now();
        }
    }

    @PreUpdate
    protected void onUpdate() {
        this.updatedAt = LocalDateTime.now();
    }

    @Generated
    public Long getIdPaquete() {
        return this.idPaquete;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Sucursal getSucursal() {
        return this.sucursal;
    }

    @Generated
    public String getNombrePaquete() {
        return this.nombrePaquete;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public BigDecimal getPrecioTotal() {
        return this.precioTotal;
    }

    @Generated
    public Integer getDuracionDias() {
        return this.duracionDias;
    }

    @Generated
    public Boolean getPromocion() {
        return this.promocion;
    }

    @Generated
    public BigDecimal getDescuento() {
        return this.descuento;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public List<PaqueteServicio> getServiciosIncluidos() {
        return this.serviciosIncluidos;
    }

    @Generated
    public void setIdPaquete(Long idPaquete) {
        this.idPaquete = idPaquete;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    @Generated
    public void setNombrePaquete(String nombrePaquete) {
        this.nombrePaquete = nombrePaquete;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setPrecioTotal(BigDecimal precioTotal) {
        this.precioTotal = precioTotal;
    }

    @Generated
    public void setDuracionDias(Integer duracionDias) {
        this.duracionDias = duracionDias;
    }

    @Generated
    public void setPromocion(Boolean promocion) {
        this.promocion = promocion;
    }

    @Generated
    public void setDescuento(BigDecimal descuento) {
        this.descuento = descuento;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    @Generated
    public void setServiciosIncluidos(List<PaqueteServicio> serviciosIncluidos) {
        this.serviciosIncluidos = serviciosIncluidos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaqueteTuristico)) {
            return false;
        }
        PaqueteTuristico other = (PaqueteTuristico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPaquete = this.getIdPaquete();
        Long other$idPaquete = other.getIdPaquete();
        if (this$idPaquete == null ? other$idPaquete != null : !((Object)this$idPaquete).equals(other$idPaquete)) {
            return false;
        }
        Integer this$duracionDias = this.getDuracionDias();
        Integer other$duracionDias = other.getDuracionDias();
        if (this$duracionDias == null ? other$duracionDias != null : !((Object)this$duracionDias).equals(other$duracionDias)) {
            return false;
        }
        Boolean this$promocion = this.getPromocion();
        Boolean other$promocion = other.getPromocion();
        if (this$promocion == null ? other$promocion != null : !((Object)this$promocion).equals(other$promocion)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Sucursal this$sucursal = this.getSucursal();
        Sucursal other$sucursal = other.getSucursal();
        if (this$sucursal == null ? other$sucursal != null : !this$sucursal.equals(other$sucursal)) {
            return false;
        }
        String this$nombrePaquete = this.getNombrePaquete();
        String other$nombrePaquete = other.getNombrePaquete();
        if (this$nombrePaquete == null ? other$nombrePaquete != null : !this$nombrePaquete.equals(other$nombrePaquete)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        BigDecimal this$precioTotal = this.getPrecioTotal();
        BigDecimal other$precioTotal = other.getPrecioTotal();
        if (this$precioTotal == null ? other$precioTotal != null : !((Object)this$precioTotal).equals(other$precioTotal)) {
            return false;
        }
        BigDecimal this$descuento = this.getDescuento();
        BigDecimal other$descuento = other.getDescuento();
        if (this$descuento == null ? other$descuento != null : !((Object)this$descuento).equals(other$descuento)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        List this$serviciosIncluidos = this.getServiciosIncluidos();
        List other$serviciosIncluidos = other.getServiciosIncluidos();
        return !(this$serviciosIncluidos == null ? other$serviciosIncluidos != null : !((Object)this$serviciosIncluidos).equals(other$serviciosIncluidos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaqueteTuristico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPaquete = this.getIdPaquete();
        result = result * 59 + ($idPaquete == null ? 43 : ((Object)$idPaquete).hashCode());
        Integer $duracionDias = this.getDuracionDias();
        result = result * 59 + ($duracionDias == null ? 43 : ((Object)$duracionDias).hashCode());
        Boolean $promocion = this.getPromocion();
        result = result * 59 + ($promocion == null ? 43 : ((Object)$promocion).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Sucursal $sucursal = this.getSucursal();
        result = result * 59 + ($sucursal == null ? 43 : $sucursal.hashCode());
        String $nombrePaquete = this.getNombrePaquete();
        result = result * 59 + ($nombrePaquete == null ? 43 : $nombrePaquete.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        BigDecimal $precioTotal = this.getPrecioTotal();
        result = result * 59 + ($precioTotal == null ? 43 : ((Object)$precioTotal).hashCode());
        BigDecimal $descuento = this.getDescuento();
        result = result * 59 + ($descuento == null ? 43 : ((Object)$descuento).hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        List $serviciosIncluidos = this.getServiciosIncluidos();
        result = result * 59 + ($serviciosIncluidos == null ? 43 : ((Object)$serviciosIncluidos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaqueteTuristico(idPaquete=" + String.valueOf(this.getIdPaquete()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", nombrePaquete=" + this.getNombrePaquete() + ", descripcion=" + this.getDescripcion() + ", precioTotal=" + String.valueOf(this.getPrecioTotal()) + ", duracionDias=" + String.valueOf(this.getDuracionDias()) + ", promocion=" + String.valueOf(this.getPromocion()) + ", descuento=" + String.valueOf(this.getDescuento()) + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", serviciosIncluidos=" + String.valueOf(this.getServiciosIncluidos()) + ")";
    }

    @Generated
    public PaqueteTuristico() {
    }

    @Generated
    public PaqueteTuristico(Long idPaquete, Empresa empresa, Sucursal sucursal, String nombrePaquete, String descripcion, BigDecimal precioTotal, Integer duracionDias, Boolean promocion, BigDecimal descuento, Boolean estado, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime deletedAt, List<PaqueteServicio> serviciosIncluidos) {
        this.idPaquete = idPaquete;
        this.empresa = empresa;
        this.sucursal = sucursal;
        this.nombrePaquete = nombrePaquete;
        this.descripcion = descripcion;
        this.precioTotal = precioTotal;
        this.duracionDias = duracionDias;
        this.promocion = promocion;
        this.descuento = descuento;
        this.estado = estado;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
        this.serviciosIncluidos = serviciosIncluidos;
    }
}

