/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.entity.Sucursal;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.sql.Date;
import lombok.Generated;

@Entity
@Table(name="personal", indexes={@Index(name="idx_personal_empresa", columnList="id_empresa")})
public class Personal {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_personal")
    private Long idPersonal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @NotBlank(message="El nombre es obligatorio")
    @Column(name="nombre", nullable=false, length=100)
    private @NotBlank(message="El nombre es obligatorio") String nombre;
    @NotBlank(message="El apellido es obligatorio")
    @Column(name="apellido", nullable=false, length=100)
    private @NotBlank(message="El apellido es obligatorio") String apellido;
    @NotBlank(message="El DNI es obligatorio")
    @Column(name="dni", nullable=false, length=20, unique=true)
    private @NotBlank(message="El DNI es obligatorio") String dni;
    @Column(name="fecha_nacimiento")
    private Date fechaNacimiento;
    @Column(name="telefono", length=20)
    private String telefono;
    @Column(name="email", length=255)
    private String email;
    @Column(name="direccion", columnDefinition="TEXT")
    private String direccion;
    @NotNull(message="El cargo es obligatorio")
    @Enumerated(value=EnumType.STRING)
    @Column(name="cargo", nullable=false)
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="El cargo es obligatorio") Personal.Cargo cargo;
    @NotNull(message="La fecha de ingreso es obligatoria")
    @Column(name="fecha_ingreso", nullable=false)
    private @NotNull(message="La fecha de ingreso es obligatoria") Date fechaIngreso;
    @Enumerated(value=EnumType.STRING)
    @Column(name="turno")
    private Turno turno = Turno.Completo;
    @Column(name="sueldo", precision=10, scale=2)
    private BigDecimal sueldo;
    @Column(name="foto", length=255)
    private String foto;
    @NotNull(message="El estado es obligatorio")
    @Column(name="estado", nullable=false)
    private @NotNull(message="El estado es obligatorio") Boolean estado = true;
    @Column(name="created_at", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private java.util.Date createdAt;
    @Column(name="updated_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private java.util.Date updatedAt;
    @Column(name="deleted_at")
    @Temporal(value=TemporalType.TIMESTAMP)
    private java.util.Date deletedAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new java.util.Date();
        this.updatedAt = new java.util.Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updatedAt = new java.util.Date();
    }

    public String getNombreCompleto() {
        return this.nombre + " " + this.apellido;
    }

    @JsonIgnore
    public boolean isActivo() {
        return this.estado != null && this.estado != false;
    }

    @Generated
    public Long getIdPersonal() {
        return this.idPersonal;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Sucursal getSucursal() {
        return this.sucursal;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getApellido() {
        return this.apellido;
    }

    @Generated
    public String getDni() {
        return this.dni;
    }

    @Generated
    public Date getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getDireccion() {
        return this.direccion;
    }

    @Generated
    public Cargo getCargo() {
        return this.cargo;
    }

    @Generated
    public Date getFechaIngreso() {
        return this.fechaIngreso;
    }

    @Generated
    public Turno getTurno() {
        return this.turno;
    }

    @Generated
    public BigDecimal getSueldo() {
        return this.sueldo;
    }

    @Generated
    public String getFoto() {
        return this.foto;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public java.util.Date getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public void setIdPersonal(Long idPersonal) {
        this.idPersonal = idPersonal;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setApellido(String apellido) {
        this.apellido = apellido;
    }

    @Generated
    public void setDni(String dni) {
        this.dni = dni;
    }

    @Generated
    public void setFechaNacimiento(Date fechaNacimiento) {
        this.fechaNacimiento = fechaNacimiento;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    @Generated
    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setFechaIngreso(Date fechaIngreso) {
        this.fechaIngreso = fechaIngreso;
    }

    @Generated
    public void setTurno(Turno turno) {
        this.turno = turno;
    }

    @Generated
    public void setSueldo(BigDecimal sueldo) {
        this.sueldo = sueldo;
    }

    @Generated
    public void setFoto(String foto) {
        this.foto = foto;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeletedAt(java.util.Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Personal)) {
            return false;
        }
        Personal other = (Personal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPersonal = this.getIdPersonal();
        Long other$idPersonal = other.getIdPersonal();
        if (this$idPersonal == null ? other$idPersonal != null : !((Object)this$idPersonal).equals(other$idPersonal)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Sucursal this$sucursal = this.getSucursal();
        Sucursal other$sucursal = other.getSucursal();
        if (this$sucursal == null ? other$sucursal != null : !this$sucursal.equals(other$sucursal)) {
            return false;
        }
        String this$nombre = this.getNombre();
        String other$nombre = other.getNombre();
        if (this$nombre == null ? other$nombre != null : !this$nombre.equals(other$nombre)) {
            return false;
        }
        String this$apellido = this.getApellido();
        String other$apellido = other.getApellido();
        if (this$apellido == null ? other$apellido != null : !this$apellido.equals(other$apellido)) {
            return false;
        }
        String this$dni = this.getDni();
        String other$dni = other.getDni();
        if (this$dni == null ? other$dni != null : !this$dni.equals(other$dni)) {
            return false;
        }
        Date this$fechaNacimiento = this.getFechaNacimiento();
        Date other$fechaNacimiento = other.getFechaNacimiento();
        if (this$fechaNacimiento == null ? other$fechaNacimiento != null : !((Object)this$fechaNacimiento).equals(other$fechaNacimiento)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        if (this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion)) {
            return false;
        }
        Cargo this$cargo = this.getCargo();
        Cargo other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        Date this$fechaIngreso = this.getFechaIngreso();
        Date other$fechaIngreso = other.getFechaIngreso();
        if (this$fechaIngreso == null ? other$fechaIngreso != null : !((Object)this$fechaIngreso).equals(other$fechaIngreso)) {
            return false;
        }
        Turno this$turno = this.getTurno();
        Turno other$turno = other.getTurno();
        if (this$turno == null ? other$turno != null : !this$turno.equals(other$turno)) {
            return false;
        }
        BigDecimal this$sueldo = this.getSueldo();
        BigDecimal other$sueldo = other.getSueldo();
        if (this$sueldo == null ? other$sueldo != null : !((Object)this$sueldo).equals(other$sueldo)) {
            return false;
        }
        String this$foto = this.getFoto();
        String other$foto = other.getFoto();
        if (this$foto == null ? other$foto != null : !this$foto.equals(other$foto)) {
            return false;
        }
        java.util.Date this$createdAt = this.getCreatedAt();
        java.util.Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        java.util.Date this$updatedAt = this.getUpdatedAt();
        java.util.Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        java.util.Date this$deletedAt = this.getDeletedAt();
        java.util.Date other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Personal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPersonal = this.getIdPersonal();
        result = result * 59 + ($idPersonal == null ? 43 : ((Object)$idPersonal).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Sucursal $sucursal = this.getSucursal();
        result = result * 59 + ($sucursal == null ? 43 : $sucursal.hashCode());
        String $nombre = this.getNombre();
        result = result * 59 + ($nombre == null ? 43 : $nombre.hashCode());
        String $apellido = this.getApellido();
        result = result * 59 + ($apellido == null ? 43 : $apellido.hashCode());
        String $dni = this.getDni();
        result = result * 59 + ($dni == null ? 43 : $dni.hashCode());
        Date $fechaNacimiento = this.getFechaNacimiento();
        result = result * 59 + ($fechaNacimiento == null ? 43 : ((Object)$fechaNacimiento).hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        Cargo $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        Date $fechaIngreso = this.getFechaIngreso();
        result = result * 59 + ($fechaIngreso == null ? 43 : ((Object)$fechaIngreso).hashCode());
        Turno $turno = this.getTurno();
        result = result * 59 + ($turno == null ? 43 : $turno.hashCode());
        BigDecimal $sueldo = this.getSueldo();
        result = result * 59 + ($sueldo == null ? 43 : ((Object)$sueldo).hashCode());
        String $foto = this.getFoto();
        result = result * 59 + ($foto == null ? 43 : $foto.hashCode());
        java.util.Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        java.util.Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        java.util.Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Personal(idPersonal=" + String.valueOf(this.getIdPersonal()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", nombre=" + this.getNombre() + ", apellido=" + this.getApellido() + ", dni=" + this.getDni() + ", fechaNacimiento=" + String.valueOf(this.getFechaNacimiento()) + ", telefono=" + this.getTelefono() + ", email=" + this.getEmail() + ", direccion=" + this.getDireccion() + ", cargo=" + String.valueOf(this.getCargo()) + ", fechaIngreso=" + String.valueOf(this.getFechaIngreso()) + ", turno=" + String.valueOf(this.getTurno()) + ", sueldo=" + String.valueOf(this.getSueldo()) + ", foto=" + this.getFoto() + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }

    @Generated
    public Personal() {
    }

    @Generated
    public Personal(Long idPersonal, Empresa empresa, Sucursal sucursal, String nombre, String apellido, String dni, Date fechaNacimiento, String telefono, String email, String direccion, Cargo cargo, Date fechaIngreso, Turno turno, BigDecimal sueldo, String foto, Boolean estado, java.util.Date createdAt, java.util.Date updatedAt, java.util.Date deletedAt) {
        this.idPersonal = idPersonal;
        this.empresa = empresa;
        this.sucursal = sucursal;
        this.nombre = nombre;
        this.apellido = apellido;
        this.dni = dni;
        this.fechaNacimiento = fechaNacimiento;
        this.telefono = telefono;
        this.email = email;
        this.direccion = direccion;
        this.cargo = cargo;
        this.fechaIngreso = fechaIngreso;
        this.turno = turno;
        this.sueldo = sueldo;
        this.foto = foto;
        this.estado = estado;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
    }
}

