/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ReservaItem;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="reservas", indexes={@Index(name="idx_reservas_empresa", columnList="id_empresa"), @Index(name="idx_reservas_cliente", columnList="id_cliente"), @Index(name="idx_reservas_fecha", columnList="fecha_reserva"), @Index(name="idx_reservas_estado", columnList="estado"), @Index(name="fk_reserva_promocion", columnList="id_promocion")})
public class Reserva {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_reserva")
    private Long idReserva;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_sucursal")
    private Sucursal sucursal;
    @NotNull(message="El cliente es obligatorio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_cliente", nullable=false)
    private @NotNull(message="El cliente es obligatorio") Cliente cliente;
    @OneToMany(mappedBy="reserva", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ReservaItem> items = new ArrayList();
    @NotNull(message="El usuario que registra es obligatorio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario", nullable=false)
    private @NotNull(message="El usuario que registra es obligatorio") Usuario usuario;
    @NotBlank(message="El c\u00f3digo de reserva es obligatorio")
    @Size(max=50, message="El c\u00f3digo de reserva no puede exceder 50 caracteres")
    @Column(name="codigo_reserva", nullable=false, length=50, unique=true)
    private @NotBlank(message="El c\u00f3digo de reserva es obligatorio") @Size(max=50, message="El c\u00f3digo de reserva no puede exceder 50 caracteres") String codigoReserva;
    @NotNull(message="La fecha de reserva es obligatoria")
    @Column(name="fecha_reserva", nullable=false)
    private @NotNull(message="La fecha de reserva es obligatoria") Date fechaReserva;
    @NotNull(message="La fecha de servicio es obligatoria")
    @Column(name="fecha_servicio", nullable=false)
    private @NotNull(message="La fecha de servicio es obligatoria") Date fechaServicio;
    @NotNull(message="El n\u00famero de personas es obligatorio")
    @Min(value=1L, message="El n\u00famero de personas debe ser al menos 1")
    @Column(name="numero_personas", nullable=false)
    private @NotNull(message="El n\u00famero de personas es obligatorio") @Min(value=1L, message="El n\u00famero de personas debe ser al menos 1") Integer numeroPersonas;
    @NotNull(message="El precio total es obligatorio")
    @DecimalMin(value="0.01", message="El precio total debe ser mayor a 0")
    @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="precio_total", nullable=false, precision=10, scale=2)
    private @NotNull(message="El precio total es obligatorio") @DecimalMin(value="0.01", message="El precio total debe ser mayor a 0") @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal precioTotal;
    @Column(name="id_promocion")
    private Long idPromocion;
    @DecimalMin(value="0.00", message="El descuento aplicado no puede ser negativo")
    @Digits(integer=10, fraction=2, message="El descuento debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="descuento_aplicado", nullable=false, precision=10, scale=2, columnDefinition="DECIMAL(10,2) DEFAULT 0.00")
    private @DecimalMin(value="0.00", message="El descuento aplicado no puede ser negativo") @Digits(integer=10, fraction=2, message="El descuento debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal descuentoAplicado = BigDecimal.ZERO;
    @NotNull(message="El estado es obligatorio")
    @Column(name="estado", nullable=false, columnDefinition="ENUM('Pendiente','Confirmada','Pago Parcial','Pagada','Cancelada','Completada') DEFAULT 'Pendiente'")
    @Convert(converter=EstadoReservaConverter.class)
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="El estado es obligatorio") Reserva.EstadoReserva estado = EstadoReserva.Pendiente;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @Column(name="evaluada", columnDefinition="TINYINT(1) DEFAULT 0")
    private Boolean evaluada = false;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;

    public boolean isActiva() {
        return this.deletedAt == null && (this.estado == EstadoReserva.Pendiente || this.estado == EstadoReserva.Confirmada || this.estado == EstadoReserva.PagoParcial || this.estado == EstadoReserva.Pagada);
    }

    public BigDecimal getPrecioFinal() {
        return this.precioTotal.subtract(this.descuentoAplicado);
    }

    public boolean puedeCancelarse() {
        return this.isActiva() && this.evaluada == false;
    }

    public boolean puedeEvaluarse() {
        return this.estado == EstadoReserva.Completada && this.evaluada == false;
    }

    public void addItem(ReservaItem item) {
        if (item == null) {
            return;
        }
        item.setReserva(this);
        this.items.add(item);
    }

    public void setItems(List<ReservaItem> nuevosItems) {
        this.items.clear();
        if (nuevosItems == null) {
            return;
        }
        nuevosItems.forEach(arg_0 -> this.addItem(arg_0));
        this.recalcularTotalesDesdeItems();
    }

    public void recalcularTotalesDesdeItems() {
        int totalPersonas = 0;
        BigDecimal total = BigDecimal.ZERO;
        for (ReservaItem item : this.items) {
            if (item.getCantidad() != null) {
                totalPersonas += item.getCantidad().intValue();
            }
            if (item.getPrecioTotal() == null) continue;
            total = total.add(item.getPrecioTotal());
        }
        if (totalPersonas > 0) {
            this.setNumeroPersonas(Integer.valueOf(totalPersonas));
        }
        this.setPrecioTotal(total);
    }

    @Generated
    public Long getIdReserva() {
        return this.idReserva;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Sucursal getSucursal() {
        return this.sucursal;
    }

    @Generated
    public Cliente getCliente() {
        return this.cliente;
    }

    @Generated
    public List<ReservaItem> getItems() {
        return this.items;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getCodigoReserva() {
        return this.codigoReserva;
    }

    @Generated
    public Date getFechaReserva() {
        return this.fechaReserva;
    }

    @Generated
    public Date getFechaServicio() {
        return this.fechaServicio;
    }

    @Generated
    public Integer getNumeroPersonas() {
        return this.numeroPersonas;
    }

    @Generated
    public BigDecimal getPrecioTotal() {
        return this.precioTotal;
    }

    @Generated
    public Long getIdPromocion() {
        return this.idPromocion;
    }

    @Generated
    public BigDecimal getDescuentoAplicado() {
        return this.descuentoAplicado;
    }

    @Generated
    public EstadoReserva getEstado() {
        return this.estado;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public Boolean getEvaluada() {
        return this.evaluada;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public void setIdReserva(Long idReserva) {
        this.idReserva = idReserva;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSucursal(Sucursal sucursal) {
        this.sucursal = sucursal;
    }

    @Generated
    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCodigoReserva(String codigoReserva) {
        this.codigoReserva = codigoReserva;
    }

    @Generated
    public void setFechaReserva(Date fechaReserva) {
        this.fechaReserva = fechaReserva;
    }

    @Generated
    public void setFechaServicio(Date fechaServicio) {
        this.fechaServicio = fechaServicio;
    }

    @Generated
    public void setNumeroPersonas(Integer numeroPersonas) {
        this.numeroPersonas = numeroPersonas;
    }

    @Generated
    public void setPrecioTotal(BigDecimal precioTotal) {
        this.precioTotal = precioTotal;
    }

    @Generated
    public void setIdPromocion(Long idPromocion) {
        this.idPromocion = idPromocion;
    }

    @Generated
    public void setDescuentoAplicado(BigDecimal descuentoAplicado) {
        this.descuentoAplicado = descuentoAplicado;
    }

    @Generated
    public void setEstado(EstadoReserva estado) {
        this.estado = estado;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setEvaluada(Boolean evaluada) {
        this.evaluada = evaluada;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reserva)) {
            return false;
        }
        Reserva other = (Reserva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idReserva = this.getIdReserva();
        Long other$idReserva = other.getIdReserva();
        if (this$idReserva == null ? other$idReserva != null : !((Object)this$idReserva).equals(other$idReserva)) {
            return false;
        }
        Integer this$numeroPersonas = this.getNumeroPersonas();
        Integer other$numeroPersonas = other.getNumeroPersonas();
        if (this$numeroPersonas == null ? other$numeroPersonas != null : !((Object)this$numeroPersonas).equals(other$numeroPersonas)) {
            return false;
        }
        Long this$idPromocion = this.getIdPromocion();
        Long other$idPromocion = other.getIdPromocion();
        if (this$idPromocion == null ? other$idPromocion != null : !((Object)this$idPromocion).equals(other$idPromocion)) {
            return false;
        }
        Boolean this$evaluada = this.getEvaluada();
        Boolean other$evaluada = other.getEvaluada();
        if (this$evaluada == null ? other$evaluada != null : !((Object)this$evaluada).equals(other$evaluada)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Sucursal this$sucursal = this.getSucursal();
        Sucursal other$sucursal = other.getSucursal();
        if (this$sucursal == null ? other$sucursal != null : !this$sucursal.equals(other$sucursal)) {
            return false;
        }
        Cliente this$cliente = this.getCliente();
        Cliente other$cliente = other.getCliente();
        if (this$cliente == null ? other$cliente != null : !this$cliente.equals(other$cliente)) {
            return false;
        }
        List this$items = this.getItems();
        List other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Usuario this$usuario = this.getUsuario();
        Usuario other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$codigoReserva = this.getCodigoReserva();
        String other$codigoReserva = other.getCodigoReserva();
        if (this$codigoReserva == null ? other$codigoReserva != null : !this$codigoReserva.equals(other$codigoReserva)) {
            return false;
        }
        Date this$fechaReserva = this.getFechaReserva();
        Date other$fechaReserva = other.getFechaReserva();
        if (this$fechaReserva == null ? other$fechaReserva != null : !((Object)this$fechaReserva).equals(other$fechaReserva)) {
            return false;
        }
        Date this$fechaServicio = this.getFechaServicio();
        Date other$fechaServicio = other.getFechaServicio();
        if (this$fechaServicio == null ? other$fechaServicio != null : !((Object)this$fechaServicio).equals(other$fechaServicio)) {
            return false;
        }
        BigDecimal this$precioTotal = this.getPrecioTotal();
        BigDecimal other$precioTotal = other.getPrecioTotal();
        if (this$precioTotal == null ? other$precioTotal != null : !((Object)this$precioTotal).equals(other$precioTotal)) {
            return false;
        }
        BigDecimal this$descuentoAplicado = this.getDescuentoAplicado();
        BigDecimal other$descuentoAplicado = other.getDescuentoAplicado();
        if (this$descuentoAplicado == null ? other$descuentoAplicado != null : !((Object)this$descuentoAplicado).equals(other$descuentoAplicado)) {
            return false;
        }
        EstadoReserva this$estado = this.getEstado();
        EstadoReserva other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        String this$observaciones = this.getObservaciones();
        String other$observaciones = other.getObservaciones();
        if (this$observaciones == null ? other$observaciones != null : !this$observaciones.equals(other$observaciones)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reserva;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idReserva = this.getIdReserva();
        result = result * 59 + ($idReserva == null ? 43 : ((Object)$idReserva).hashCode());
        Integer $numeroPersonas = this.getNumeroPersonas();
        result = result * 59 + ($numeroPersonas == null ? 43 : ((Object)$numeroPersonas).hashCode());
        Long $idPromocion = this.getIdPromocion();
        result = result * 59 + ($idPromocion == null ? 43 : ((Object)$idPromocion).hashCode());
        Boolean $evaluada = this.getEvaluada();
        result = result * 59 + ($evaluada == null ? 43 : ((Object)$evaluada).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Sucursal $sucursal = this.getSucursal();
        result = result * 59 + ($sucursal == null ? 43 : $sucursal.hashCode());
        Cliente $cliente = this.getCliente();
        result = result * 59 + ($cliente == null ? 43 : $cliente.hashCode());
        List $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Usuario $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $codigoReserva = this.getCodigoReserva();
        result = result * 59 + ($codigoReserva == null ? 43 : $codigoReserva.hashCode());
        Date $fechaReserva = this.getFechaReserva();
        result = result * 59 + ($fechaReserva == null ? 43 : ((Object)$fechaReserva).hashCode());
        Date $fechaServicio = this.getFechaServicio();
        result = result * 59 + ($fechaServicio == null ? 43 : ((Object)$fechaServicio).hashCode());
        BigDecimal $precioTotal = this.getPrecioTotal();
        result = result * 59 + ($precioTotal == null ? 43 : ((Object)$precioTotal).hashCode());
        BigDecimal $descuentoAplicado = this.getDescuentoAplicado();
        result = result * 59 + ($descuentoAplicado == null ? 43 : ((Object)$descuentoAplicado).hashCode());
        EstadoReserva $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        String $observaciones = this.getObservaciones();
        result = result * 59 + ($observaciones == null ? 43 : $observaciones.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Reserva(idReserva=" + String.valueOf(this.getIdReserva()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", sucursal=" + String.valueOf(this.getSucursal()) + ", cliente=" + String.valueOf(this.getCliente()) + ", items=" + String.valueOf(this.getItems()) + ", usuario=" + String.valueOf(this.getUsuario()) + ", codigoReserva=" + this.getCodigoReserva() + ", fechaReserva=" + String.valueOf(this.getFechaReserva()) + ", fechaServicio=" + String.valueOf(this.getFechaServicio()) + ", numeroPersonas=" + String.valueOf(this.getNumeroPersonas()) + ", precioTotal=" + String.valueOf(this.getPrecioTotal()) + ", idPromocion=" + String.valueOf(this.getIdPromocion()) + ", descuentoAplicado=" + String.valueOf(this.getDescuentoAplicado()) + ", estado=" + String.valueOf(this.getEstado()) + ", observaciones=" + this.getObservaciones() + ", evaluada=" + String.valueOf(this.getEvaluada()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }

    @Generated
    public Reserva() {
    }
}

