/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Sucursal;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SucursalRepository
extends JpaRepository<Sucursal, Long> {
    @Query(value="SELECT s FROM Sucursal s WHERE s.deletedAt IS NULL ORDER BY s.createdAt DESC")
    public List<Sucursal> findAllActivas();

    @Query(value="SELECT s FROM Sucursal s WHERE s.deletedAt IS NULL AND (:estado IS NULL OR s.estado = :estado) AND (:empresaId IS NULL OR s.empresa.idEmpresa = :empresaId) AND (:busqueda IS NULL OR LOWER(s.nombreSucursal) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.ubicacion) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.email) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.direccion) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(s.gerente) LIKE LOWER(CONCAT('%', :busqueda, '%'))) ORDER BY s.createdAt DESC")
    public List<Sucursal> findByFiltros(@Param(value="busqueda") String var1, @Param(value="estado") Integer var2, @Param(value="empresaId") Long var3);

    @Query(value="SELECT s FROM Sucursal s WHERE s.idSucursal = :id AND s.deletedAt IS NULL")
    public Optional<Sucursal> findActivaById(@Param(value="id") Long var1);

    @Query(value="SELECT CASE WHEN COUNT(s) > 0 THEN true ELSE false END FROM Sucursal s WHERE s.deletedAt IS NULL AND LOWER(s.nombreSucursal) = LOWER(:nombre) AND s.empresa.idEmpresa = :empresaId")
    public boolean existsActivaByNombreAndEmpresa(@Param(value="nombre") String var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT CASE WHEN COUNT(s) > 0 THEN true ELSE false END FROM Sucursal s WHERE s.deletedAt IS NULL AND LOWER(s.nombreSucursal) = LOWER(:nombre) AND s.empresa.idEmpresa = :empresaId AND s.idSucursal <> :id")
    public boolean existsActivaByNombreAndEmpresaExcludingId(@Param(value="nombre") String var1, @Param(value="empresaId") Long var2, @Param(value="id") Long var3);
}

