/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ClienteResponse;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.repository.ClienteRepository;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.SucursalRepository;
import com.sistema.turistico.security.TenantContext;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ClienteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClienteService.class);
    private final ClienteRepository clienteRepository;
    private final EmpresaRepository empresaRepository;
    private final SucursalRepository sucursalRepository;

    public Cliente create(Cliente cliente) {
        log.info("Creando nuevo cliente: {} {}", (Object)(cliente != null ? cliente.getNombre() : null), (Object)(cliente != null ? cliente.getApellido() : null));
        if (cliente == null) {
            throw new IllegalArgumentException("El cliente es obligatorio");
        }
        Long empresaSolicitada = cliente.getEmpresa() != null ? cliente.getEmpresa().getIdEmpresa() : null;
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)empresaSolicitada);
        this.normalizarCliente(cliente);
        if (cliente.getEmail() != null && this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(empresaId, cliente.getEmail(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un cliente con este email en la empresa");
        }
        if (cliente.getDni() != null && this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(empresaId, cliente.getDni(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un cliente con este DNI en la empresa");
        }
        cliente.setEmpresa(this.obtenerEmpresaActiva(empresaId));
        if (cliente.getSucursal() != null && cliente.getSucursal().getIdSucursal() != null) {
            Sucursal sucursal = this.obtenerSucursalActiva(cliente.getSucursal().getIdSucursal(), empresaId);
            cliente.setSucursal(sucursal);
        } else {
            cliente.setSucursal(null);
        }
        if (cliente.getNivelMembresia() == null) {
            cliente.setNivelMembresia(Cliente.NivelMembresia.Bronce);
        }
        if (cliente.getPuntosFidelizacion() == null) {
            cliente.setPuntosFidelizacion(Integer.valueOf(0));
        }
        cliente.setEstado(Boolean.TRUE);
        cliente.setDeletedAt(null);
        this.aplicarEncriptacion(cliente);
        Cliente savedCliente = (Cliente)this.clienteRepository.save((Object)cliente);
        log.info("Cliente creado exitosamente con ID: {}", (Object)savedCliente.getIdCliente());
        return savedCliente;
    }

    @Transactional(readOnly=true)
    public Optional<Cliente> findById(Long id) {
        log.debug("Buscando cliente con ID: {}", (Object)id);
        return this.clienteRepository.findById((Object)id).filter(cliente -> cliente.getDeletedAt() == null).map(cliente -> {
            this.validarPertenencia(cliente);
            return cliente;
        });
    }

    @Transactional(readOnly=true)
    public List<Cliente> findByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando clientes de empresa ID: {}", (Object)empresaFiltrada);
        return this.clienteRepository.findByEmpresaId(empresaFiltrada);
    }

    @Transactional(readOnly=true)
    public List<Cliente> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando clientes en empresa {} con t\u00e9rmino: {}", (Object)empresaFiltrada, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.clienteRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaFiltrada);
        }
        return this.clienteRepository.findByEmpresaIdAndBusqueda(empresaFiltrada, busqueda.trim());
    }

    public Cliente update(Long id, Cliente clienteActualizado) {
        log.info("Actualizando cliente ID: {}", (Object)id);
        if (clienteActualizado == null) {
            throw new IllegalArgumentException("El cliente es obligatorio");
        }
        Cliente clienteExistente = this.obtenerClienteAutorizado(id);
        this.normalizarCliente(clienteActualizado);
        if (clienteActualizado.getEmail() != null && this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(clienteExistente.getEmpresa().getIdEmpresa(), clienteActualizado.getEmail(), id)) {
            throw new IllegalArgumentException("Ya existe un cliente con este email en la empresa");
        }
        if (clienteActualizado.getDni() != null && this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(clienteExistente.getEmpresa().getIdEmpresa(), clienteActualizado.getDni(), id)) {
            throw new IllegalArgumentException("Ya existe un cliente con este DNI en la empresa");
        }
        clienteExistente.setNombre(clienteActualizado.getNombre());
        clienteExistente.setApellido(clienteActualizado.getApellido());
        clienteExistente.setEmail(clienteActualizado.getEmail());
        clienteExistente.setTelefono(clienteActualizado.getTelefono());
        clienteExistente.setDni(clienteActualizado.getDni());
        clienteExistente.setFechaNacimiento(clienteActualizado.getFechaNacimiento());
        clienteExistente.setNacionalidad(clienteActualizado.getNacionalidad());
        clienteExistente.setPreferenciasViaje(clienteActualizado.getPreferenciasViaje());
        if (clienteActualizado.getNivelMembresia() != null) {
            clienteExistente.setNivelMembresia(clienteActualizado.getNivelMembresia());
        }
        if (clienteActualizado.getSucursal() != null && clienteActualizado.getSucursal().getIdSucursal() != null) {
            Sucursal sucursal = this.obtenerSucursalActiva(clienteActualizado.getSucursal().getIdSucursal(), clienteExistente.getEmpresa().getIdEmpresa());
            clienteExistente.setSucursal(sucursal);
        } else {
            clienteExistente.setSucursal(null);
        }
        this.aplicarEncriptacion(clienteExistente);
        Cliente updatedCliente = (Cliente)this.clienteRepository.save((Object)clienteExistente);
        log.info("Cliente actualizado exitosamente: {}", (Object)updatedCliente.getIdCliente());
        return updatedCliente;
    }

    public void delete(Long id) {
        log.info("Eliminando cliente ID: {} (soft delete)", (Object)id);
        Cliente cliente = this.obtenerClienteAutorizado(id);
        if (cliente.getDeletedAt() != null) {
            throw new IllegalArgumentException("El cliente ya fue eliminado");
        }
        cliente.setEstado(Boolean.valueOf(false));
        cliente.setDeletedAt(LocalDateTime.now());
        this.clienteRepository.save((Object)cliente);
        log.info("Cliente eliminado exitosamente: {}", (Object)id);
    }

    @Transactional(readOnly=true)
    public boolean existsByEmpresaAndEmail(Long empresaId, String email) {
        String emailNormalizado;
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        String string = emailNormalizado = email != null ? email.trim().toLowerCase() : null;
        return emailNormalizado != null && this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(empresaFiltrada, emailNormalizado, Long.valueOf(0L));
    }

    @Transactional(readOnly=true)
    public boolean existsByEmpresaAndDni(Long empresaId, String dni) {
        String dniNormalizado;
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        String string = dniNormalizado = dni != null ? dni.trim() : null;
        return dniNormalizado != null && this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(empresaFiltrada, dniNormalizado, Long.valueOf(0L));
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        return this.clienteRepository.countByEmpresaId(empresaFiltrada);
    }

    public ClienteResponse toResponse(Cliente cliente) {
        ClienteResponse response = new ClienteResponse();
        response.setIdCliente(cliente.getIdCliente());
        response.setNombre(cliente.getNombre());
        response.setApellido(cliente.getApellido());
        response.setEmail(cliente.getEmail());
        response.setTelefono(cliente.getTelefono());
        response.setDni(cliente.getDni());
        response.setFechaNacimiento(cliente.getFechaNacimiento() != null ? cliente.getFechaNacimiento().toLocalDate() : null);
        response.setNacionalidad(cliente.getNacionalidad());
        response.setPreferenciasViaje(cliente.getPreferenciasViaje());
        response.setEstado(cliente.getEstado().booleanValue());
        response.setIdSucursal(cliente.getSucursal() != null ? cliente.getSucursal().getIdSucursal() : null);
        response.setNombreSucursal(cliente.getSucursal() != null ? cliente.getSucursal().getNombreSucursal() : null);
        response.setCreatedAt(cliente.getCreatedAt() != null ? cliente.getCreatedAt().toString() : null);
        response.setUpdatedAt(cliente.getUpdatedAt() != null ? cliente.getUpdatedAt().toString() : null);
        return response;
    }

    private void normalizarCliente(Cliente cliente) {
        if (cliente.getNombre() != null) {
            cliente.setNombre(cliente.getNombre().trim());
        }
        if (cliente.getApellido() != null) {
            cliente.setApellido(cliente.getApellido().trim());
        }
        if (cliente.getEmail() != null && !cliente.getEmail().isBlank()) {
            cliente.setEmail(cliente.getEmail().trim().toLowerCase());
        } else {
            cliente.setEmail(null);
        }
        if (cliente.getTelefono() != null && !cliente.getTelefono().isBlank()) {
            cliente.setTelefono(cliente.getTelefono().trim());
        } else {
            cliente.setTelefono(null);
        }
        if (cliente.getDni() != null && !cliente.getDni().isBlank()) {
            cliente.setDni(cliente.getDni().trim());
        } else {
            cliente.setDni(null);
        }
        if (cliente.getNacionalidad() != null) {
            cliente.setNacionalidad(cliente.getNacionalidad().trim());
        }
        if (cliente.getPreferenciasViaje() != null) {
            cliente.setPreferenciasViaje(cliente.getPreferenciasViaje().trim());
        }
    }

    private void aplicarEncriptacion(Cliente cliente) {
        if (cliente.getEmail() != null) {
            cliente.setEmailEncriptado(cliente.getEmail().getBytes(StandardCharsets.UTF_8));
        } else {
            cliente.setEmailEncriptado(null);
        }
        if (cliente.getTelefono() != null) {
            cliente.setTelefonoEncriptado(cliente.getTelefono().getBytes(StandardCharsets.UTF_8));
        } else {
            cliente.setTelefonoEncriptado(null);
        }
    }

    private Cliente obtenerClienteAutorizado(Long id) {
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        if (cliente.getDeletedAt() != null) {
            throw new IllegalArgumentException("Cliente no encontrado");
        }
        this.validarPertenencia(cliente);
        return cliente;
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private Empresa obtenerEmpresaActiva(Long empresaId) {
        return (Empresa)this.empresaRepository.findActivaById(empresaId).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    private Sucursal obtenerSucursalActiva(Long sucursalId, Long empresaId) {
        Sucursal sucursal = (Sucursal)this.sucursalRepository.findActivaById(sucursalId).orElseThrow(() -> new IllegalArgumentException("Sucursal no encontrada"));
        if (sucursal.getEmpresa() == null || !sucursal.getEmpresa().getIdEmpresa().equals(empresaId)) {
            throw new IllegalArgumentException("La sucursal no pertenece a la empresa especificada");
        }
        return sucursal;
    }

    private void validarPertenencia(Cliente cliente) {
        if (!this.esSuperAdmin()) {
            Long empresaCliente;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaCliente = cliente.getEmpresa() != null ? cliente.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaCliente)) {
                throw new IllegalArgumentException("El cliente no pertenece a la empresa actual");
            }
        }
    }

    @Generated
    public ClienteService(ClienteRepository clienteRepository, EmpresaRepository empresaRepository, SucursalRepository sucursalRepository) {
        this.clienteRepository = clienteRepository;
        this.empresaRepository = empresaRepository;
        this.sucursalRepository = sucursalRepository;
    }
}

