/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ReservaResponse;
import com.sistema.turistico.entity.CategoriaServicio;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.Personal;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.entity.Venta;
import com.sistema.turistico.repository.CategoriaServicioRepository;
import com.sistema.turistico.repository.ClienteRepository;
import com.sistema.turistico.repository.EvaluacionServicioRepository;
import com.sistema.turistico.repository.PaqueteTuristicoRepository;
import com.sistema.turistico.repository.PersonalRepository;
import com.sistema.turistico.repository.ReservaRepository;
import com.sistema.turistico.repository.ServicioTuristicoRepository;
import com.sistema.turistico.repository.VentaRepository;
import com.sistema.turistico.security.TenantContext;
import com.sistema.turistico.service.ReservaService;
import com.sistema.turistico.service.VentaService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReportesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportesService.class);
    private final ReservaRepository reservaRepository;
    private final VentaRepository ventaRepository;
    private final ClienteRepository clienteRepository;
    private final PersonalRepository personalRepository;
    private final ServicioTuristicoRepository servicioTuristicoRepository;
    private final PaqueteTuristicoRepository paqueteTuristicoRepository;
    private final CategoriaServicioRepository categoriaServicioRepository;
    private final EvaluacionServicioRepository evaluacionServicioRepository;
    private final ReservaService reservaService;
    private final VentaService ventaService;

    public Map<String, Object> reporteReservas(Long empresaId, Long idSucursal, LocalDate fechaInicio, LocalDate fechaFin, String estado) {
        List reservas;
        LocalDate fin;
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        LocalDate inicio = fechaInicio != null ? fechaInicio : LocalDate.now().minusMonths(1L);
        LocalDate localDate = fin = fechaFin != null ? fechaFin : LocalDate.now();
        if (idSucursal != null) {
            reservas = this.reservaRepository.findByEmpresaIdAndSucursalId(empresaFiltrada, idSucursal);
            reservas = reservas.stream().filter(r -> {
                Long sucursalReserva;
                Long l2 = sucursalReserva = r.getSucursal() != null ? r.getSucursal().getIdSucursal() : null;
                return sucursalReserva != null && idSucursal.equals(sucursalReserva);
            }).filter(r -> {
                Date fechaServicio = r.getFechaServicio();
                if (fechaServicio == null) {
                    return false;
                }
                LocalDate fechaLocal = fechaServicio.toLocalDate();
                return !fechaLocal.isBefore(inicio) && !fechaLocal.isAfter(fin);
            }).collect(Collectors.toList());
        } else {
            reservas = this.reservaRepository.findByEmpresaAndFechaRango(empresaFiltrada, inicio, fin);
        }
        if (estado != null && !estado.isEmpty()) {
            reservas = reservas.stream().filter(r -> r.getEstado() != null && estado.equals(r.getEstado().name())).collect(Collectors.toList());
        }
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("fechaInicio", inicio);
        resumen.put("fechaFin", fin);
        List reservasDtos = reservas.stream().map(arg_0 -> this.buildReservaReporte(arg_0)).collect(Collectors.toList());
        resumen.put("reservasRaw", reservasDtos);
        resumen.put("totalReservas", reservas.size());
        resumen.put("reservasPorEstado", reservas.stream().collect(Collectors.groupingBy(Reserva::getEstado, Collectors.counting())));
        resumen.put("totalMonto", reservas.stream().map(Reserva::getPrecioTotal).reduce(BigDecimal.ZERO, BigDecimal::add));
        return resumen;
    }

    public Map<String, Object> reporteVentas(Long empresaId, Long idSucursal, LocalDate fechaInicio, LocalDate fechaFin) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        LocalDate inicio = fechaInicio != null ? fechaInicio : LocalDate.now().minusMonths(1L);
        LocalDate fin = fechaFin != null ? fechaFin : LocalDate.now();
        LocalDateTime inicioDT = inicio.atStartOfDay();
        LocalDateTime finDT = fin.atTime(LocalTime.MAX);
        List ventas = this.ventaRepository.findByFiltros(empresaFiltrada, idSucursal, inicioDT, finDT, null, Boolean.TRUE);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("fechaInicio", inicio);
        resumen.put("fechaFin", fin);
        List ventasDtos = ventas.stream().map(arg_0 -> ((VentaService)this.ventaService).toResponse(arg_0)).collect(Collectors.toList());
        resumen.put("ventasRaw", ventasDtos);
        resumen.put("totalVentas", ventas.size());
        resumen.put("montoTotal", ventas.stream().map(Venta::getMontoTotal).reduce(BigDecimal.ZERO, BigDecimal::add));
        resumen.put("ventasPorMetodoPago", ventas.stream().collect(Collectors.groupingBy(Venta::getMetodoPago, Collectors.counting())));
        return resumen;
    }

    public Map<String, Object> reporteClientes(Long empresaId, Long idSucursal) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        List clientes = idSucursal != null ? this.clienteRepository.findByEmpresaIdAndSucursalId(empresaFiltrada, idSucursal) : this.clienteRepository.findByEmpresaId(empresaFiltrada);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("clientesRaw", clientes);
        resumen.put("totalClientes", clientes.size());
        resumen.put("clientesActivos", clientes.stream().filter(Cliente::getEstado).count());
        resumen.put("clientesPorNacionalidad", clientes.stream().filter(c -> c.getNacionalidad() != null).collect(Collectors.groupingBy(Cliente::getNacionalidad, Collectors.counting())));
        resumen.put("clientesPorNivelMembresia", clientes.stream().collect(Collectors.groupingBy(Cliente::getNivelMembresia, Collectors.counting())));
        return resumen;
    }

    public Map<String, Object> reportePersonal(Long empresaId, Long idSucursal) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        List personal = idSucursal != null ? this.personalRepository.findWithFilters(empresaFiltrada, idSucursal, null, null, null) : this.personalRepository.findByEmpresaId(empresaFiltrada);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("personalRaw", personal);
        resumen.put("totalPersonal", personal.size());
        resumen.put("personalActivo", personal.stream().filter(Personal::getEstado).count());
        resumen.put("personalPorCargo", personal.stream().collect(Collectors.groupingBy(Personal::getCargo, Collectors.counting())));
        resumen.put("personalPorTurno", personal.stream().collect(Collectors.groupingBy(Personal::getTurno, Collectors.counting())));
        return resumen;
    }

    public Map<String, Object> reporteServicios(Long empresaId, Long idSucursal) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        List servicios = idSucursal != null ? this.servicioTuristicoRepository.findByEmpresaIdAndSucursalId(empresaFiltrada, idSucursal) : this.servicioTuristicoRepository.findByEmpresaId(empresaFiltrada);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("serviciosRaw", servicios);
        resumen.put("totalServicios", servicios.size());
        resumen.put("serviciosActivos", servicios.stream().filter(ServicioTuristico::getEstado).count());
        resumen.put("serviciosPorTipo", servicios.stream().collect(Collectors.groupingBy(ServicioTuristico::getTipoServicio, Collectors.counting())));
        Map<Long, Long> serviciosPorCategoria = servicios.stream().filter(s -> s.getIdCategoria() != null).collect(Collectors.groupingBy(ServicioTuristico::getIdCategoria, Collectors.counting()));
        LinkedHashMap categoriasConNombre = new LinkedHashMap();
        if (!serviciosPorCategoria.isEmpty()) {
            Set<Long> categoriasIds = serviciosPorCategoria.keySet();
            Map<Long, String> nombresCategorias = this.categoriaServicioRepository.findByIdCategoriaIn(categoriasIds).stream().collect(Collectors.toMap(CategoriaServicio::getIdCategoria, CategoriaServicio::getNombreCategoria));
            serviciosPorCategoria.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(entry -> {
                Long categoriaId = (Long)entry.getKey();
                String nombre = (String)((Object)nombresCategorias.getOrDefault(categoriaId, "Categoria #" + String.valueOf(categoriaId)));
                categoriasConNombre.put(nombre, (Long)entry.getValue());
            });
        }
        resumen.put("serviciosPorCategoria", categoriasConNombre);
        return resumen;
    }

    public Map<String, Object> reportePaquetes(Long empresaId, Long idSucursal) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        List paquetes = idSucursal != null ? this.paqueteTuristicoRepository.findByEmpresaIdAndSucursalId(empresaFiltrada, idSucursal) : this.paqueteTuristicoRepository.findByEmpresaIdEmpresa(empresaFiltrada);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("paquetesRaw", paquetes);
        resumen.put("totalPaquetes", paquetes.size());
        resumen.put("paquetesActivos", paquetes.stream().filter(PaqueteTuristico::getEstado).count());
        resumen.put("paquetesConPromocion", paquetes.stream().filter(PaqueteTuristico::getPromocion).count());
        if (!paquetes.isEmpty()) {
            BigDecimal total = paquetes.stream().map(PaqueteTuristico::getPrecioTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            resumen.put("precioPromedio", total.divide(BigDecimal.valueOf(paquetes.size()), 2, RoundingMode.HALF_UP));
        } else {
            resumen.put("precioPromedio", BigDecimal.ZERO);
        }
        return resumen;
    }

    public Map<String, Object> reporteEvaluaciones(Long empresaId, LocalDate fechaInicio, LocalDate fechaFin) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId, (String)"Debe especificar una empresa para generar el reporte");
        LocalDate inicio = fechaInicio != null ? fechaInicio : LocalDate.now().minusMonths(1L);
        LocalDate fin = fechaFin != null ? fechaFin : LocalDate.now();
        List evaluaciones = this.evaluacionServicioRepository.findByFechaRango(empresaFiltrada, inicio, fin);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("fechaInicio", inicio);
        resumen.put("fechaFin", fin);
        resumen.put("totalEvaluaciones", evaluaciones.size());
        resumen.put("promedioGeneral", evaluaciones.stream().filter(e -> e.getCalificacionGeneral() != null).mapToDouble(e -> e.getCalificacionGeneral().doubleValue()).average().orElse(0.0));
        resumen.put("promedioGuia", evaluaciones.stream().filter(e -> e.getCalificacionGuia() != null).mapToDouble(e -> e.getCalificacionGuia().doubleValue()).average().orElse(0.0));
        return resumen;
    }

    private ReservaResponse buildReservaReporte(Reserva reserva) {
        ReservaResponse response = this.reservaService.toResponse(reserva);
        if (reserva.getSucursal() != null) {
            response.setIdSucursal(reserva.getSucursal().getIdSucursal());
            if (response.getNombreSucursal() == null) {
                response.setNombreSucursal(reserva.getSucursal().getNombreSucursal());
            }
        }
        return response;
    }

    @Generated
    public ReportesService(ReservaRepository reservaRepository, VentaRepository ventaRepository, ClienteRepository clienteRepository, PersonalRepository personalRepository, ServicioTuristicoRepository servicioTuristicoRepository, PaqueteTuristicoRepository paqueteTuristicoRepository, CategoriaServicioRepository categoriaServicioRepository, EvaluacionServicioRepository evaluacionServicioRepository, ReservaService reservaService, VentaService ventaService) {
        this.reservaRepository = reservaRepository;
        this.ventaRepository = ventaRepository;
        this.clienteRepository = clienteRepository;
        this.personalRepository = personalRepository;
        this.servicioTuristicoRepository = servicioTuristicoRepository;
        this.paqueteTuristicoRepository = paqueteTuristicoRepository;
        this.categoriaServicioRepository = categoriaServicioRepository;
        this.evaluacionServicioRepository = evaluacionServicioRepository;
        this.reservaService = reservaService;
        this.ventaService = ventaService;
    }
}

